% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-trajectory.R
\name{Trajectory}
\alias{Trajectory}
\title{Simulate Trajectories of Variables}
\usage{
Trajectory(mu0, time, phi, med)
}
\arguments{
\item{mu0}{Numeric vector.
Initial values of the variables.}

\item{time}{Positive integer.
Number of time points.}

\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).
\code{phi} should have row and column names
pertaining to the variables in the system.}

\item{med}{Character vector.
Name/s of the mediator variable/s in \code{phi}.}
}
\value{
Returns an object
of class \code{ctmedtraj} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{fun}{Function used ("Trajectory").}
\item{output}{A data frame of simulated data.}
}
}
\description{
This function simulates trajectories of variables
without measurement error or process noise.
\code{Total} corresponds to the total effect
and \code{Direct} corresponds to the portion of the total effect
where the indirect effect is removed.
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")

traj <- Trajectory(
  mu0 = c(3, 3, -3),
  time = 150,
  phi = phi,
  med = "m"
)
plot(traj)

# Methods -------------------------------------------------------------------
# Trajectory has a number of methods including
# print, summary, and plot

traj <- Trajectory(
  mu0 = c(3, 3, -3),
  time = 25,
  phi = phi,
  med = "m"
)
print(traj)
summary(traj)
plot(traj)

}
\seealso{
Other Continuous Time Mediation Functions: 
\code{\link{DeltaBeta}()},
\code{\link{DeltaBetaStd}()},
\code{\link{DeltaIndirectCentral}()},
\code{\link{DeltaMed}()},
\code{\link{DeltaMedStd}()},
\code{\link{DeltaTotalCentral}()},
\code{\link{Direct}()},
\code{\link{DirectStd}()},
\code{\link{ExpCov}()},
\code{\link{ExpMean}()},
\code{\link{Indirect}()},
\code{\link{IndirectCentral}()},
\code{\link{IndirectStd}()},
\code{\link{MCBeta}()},
\code{\link{MCBetaStd}()},
\code{\link{MCIndirectCentral}()},
\code{\link{MCMed}()},
\code{\link{MCMedStd}()},
\code{\link{MCPhi}()},
\code{\link{MCTotalCentral}()},
\code{\link{Med}()},
\code{\link{MedStd}()},
\code{\link{PosteriorBeta}()},
\code{\link{PosteriorIndirectCentral}()},
\code{\link{PosteriorMed}()},
\code{\link{PosteriorPhi}()},
\code{\link{PosteriorTotalCentral}()},
\code{\link{Total}()},
\code{\link{TotalCentral}()},
\code{\link{TotalStd}()}
}
\concept{Continuous Time Mediation Functions}
\keyword{cTMed}
\keyword{effects}
\keyword{path}
