% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators_weights.R
\name{calculateWeightsGSCAm}
\alias{calculateWeightsGSCAm}
\title{Calculate weights using GSCAm}
\usage{
calculateWeightsGSCAm(
  .X                           = args_default()$.X,
  .csem_model                  = args_default()$.csem_model,
  .conv_criterion              = args_default()$.conv_criterion,
  .iter_max                    = args_default()$.iter_max,
  .starting_values             = args_default()$.starting_values,
  .tolerance                   = args_default()$.tolerance
   )
}
\arguments{
\item{.X}{A matrix of processed data (scaled, cleaned and ordered).}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.conv_criterion}{Character string. The criterion to use for the convergence check.
One of: "\emph{diff_absolute}", "\emph{diff_squared}", or "\emph{diff_relative}". Defaults
to "\emph{diff_absolute}".}

\item{.iter_max}{Integer. The maximum number of iterations allowed.
If \code{iter_max = 1} and \code{.approach_weights = "PLS-PM"} one-step weights are returned.
If the algorithm exceeds the specified number, weights of iteration step
\code{.iter_max - 1}  will be returned with a warning. Defaults to \code{100}.}

\item{.starting_values}{A named list of vectors where the
list names are the construct names whose indicator weights the user
wishes to set. The vectors must be named vectors of \code{"indicator_name" = value}
pairs, where \code{value} is the (scaled or unscaled) starting weight. Defaults to \code{NULL}.}

\item{.tolerance}{Double. The tolerance criterion for convergence.
Defaults to \code{1e-05}.}
}
\value{
A list with the elements
\describe{
\item{\verb{$W}}{A (J x K) matrix of estimated weights.}
\item{\verb{$C}}{The (J x K) matrix of estimated loadings.}
\item{\verb{$B}}{The (J x J) matrix of estimated path coefficients.}
\item{\verb{$E}}{\code{NULL}}
\item{\verb{$Modes}}{A named vector of Modes used for the outer estimation, for GSCA
the mode is automatically set to 'gsca'.}
\item{\verb{$Conv_status}}{The convergence status. \code{TRUE} if the algorithm has converged
and \code{FALSE} otherwise.}
\item{\verb{$Iterations}}{The number of iterations required.}
}
}
\description{
Calculate composite weights using generalized structured component analysis
with uniqueness terms (GSCAm) proposed by \insertCite{Hwang2017;textual}{cSEM}.
}
\details{
If there are only constructs modeled as common factors
calling \code{\link[=csem]{csem()}} with \code{.appraoch_weights = "GSCA"} will automatically call
\code{\link[=calculateWeightsGSCAm]{calculateWeightsGSCAm()}} unless \code{.disattenuate = FALSE}.
GSCAm currently only works for pure common factor models. The reason is that the implementation
in \pkg{cSEM} is based on (the appendix) of \insertCite{Hwang2017;textual}{cSEM}.
Following the appendix, GSCAm fails if there is at least one construct
modeled as a composite because calculating weight estimates with GSCAm leads to a product
involving the measurement matrix. This matrix does not have full rank
if a construct modeled as a composite is present.
The reason is that the measurement matrix has a zero row for every construct
which is a pure composite (i.e. all related loadings are zero)
and, therefore, leads to a non-invertible matrix when multiplying it with its transposed.
}
\references{
\insertAllCited{}
}
