% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_arguments.R
\name{args_assess_dotdotdot}
\alias{args_assess_dotdotdot}
\title{Internal: Complete list of assess()'s ... arguments}
\arguments{
\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.closed_form_ci}{Logical. Should a closed-form confidence interval be computed?
Defaults to \code{FALSE}.}

\item{.model_implied}{Logical. Should the RMS_theta be computed using the
model-implied construct correlation matrix (\code{TRUE}) or the construct correlation matrix
based on V(eta) = WSW' divided by the square root of the respective
reliabilities (\code{FALSE}). Defaults to \code{FALSE}.}

\item{.null_model}{Logical. Should the degrees of freedom for the null model
be computed? Defaults to \code{FALSE}.}

\item{.saturated}{Logical. Should a saturated structural model be used?
Defaults to \code{FALSE}.}

\item{.type_vcv}{Character string. Which model-implied correlation
matrix is calculated?
One of "\emph{indicator}" or "\emph{construct}". Defaults to "\emph{indicator}".}
}
\description{
A complete alphabetical list of all possible arguments accepted by \code{assess()}'s \code{...}
(dotdotdot) argument.
}
\details{
Most arguments supplied to the \code{...} argument of \code{assess()} are only
accepted by a subset of the functions called by \code{assess()}. The following
list shows which argument is passed to which (internal) function:
\describe{
\item{.alpha}{Accepted by/Passed down to: \code{\link[=calculateRhoT]{calculateRhoT()}}}
\item{.closed_form_ci}{Accepted by/Passed down to: \code{\link[=calculateRhoT]{calculateRhoT()}}}
\item{.model_implied}{Accepted by/Passed down to: \code{\link[=calculateRMSTheta]{calculateRMSTheta()}}}
\item{.null_model}{Accepted by/Passed down to: \code{\link[=calculateDf]{calculateDf()}}}
\item{.saturated}{Accepted by/Passed down to: \code{\link[=calculateSRMR]{calculateSRMR()}},
\code{\link[=calculateDG]{calculateDG()}}, \code{\link[=calculateDL]{calculateDL()}}, \code{\link[=calculateDML]{calculateDML()}}and subsequently \code{\link[=fit]{fit()}}.}
\item{.type_vcv}{Accepted by/Passed down to: \code{\link[=calculateSRMR]{calculateSRMR()}},
\code{\link[=calculateDG]{calculateDG()}}, \code{\link[=calculateDL]{calculateDL()}}, \code{\link[=calculateDML]{calculateDML()}} and subsequently \code{\link[=fit]{fit()}}.}
}
}
\keyword{internal}
