% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{derive}
\alias{derive}
\title{Derivative of regression model}
\usage{
derive(model, order = 1)
}
\arguments{
\item{model}{The regression model or a cnorm object}

\item{order}{The degree of the derivate, default: 1}
}
\value{
The derived coefficients
}
\description{
Calculates the derivative of the location / norm value from the regression model with the first
derivative as the default. This is useful for finding violations of model assumptions and problematic
distribution features as f. e. bottom and ceiling effects, non-progressive norm scores within an
age group or in general #' intersecting percentile curves.
}
\examples{
m <- cnorm(raw = elfe$raw, group = elfe$group)
derivedCoefficients <- derive(m)
}
\seealso{
Other model: 
\code{\link{bestModel}()},
\code{\link{checkConsistency}()},
\code{\link{cnorm.cv}()},
\code{\link{modelSummary}()},
\code{\link{print.cnorm}()},
\code{\link{printSubset}()},
\code{\link{rangeCheck}()},
\code{\link{regressionFunction}()},
\code{\link{summary.cnorm}()}
}
\concept{model}
