% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcox.R
\name{predictRawBC}
\alias{predictRawBC}
\title{Calculate the raw score for a given percentile based on the parametric box cox distribution}
\usage{
predictRawBC(boxcoxParameters, percentile)
}
\arguments{
\item{boxcoxParameters}{The parameters of the box cox power function, calculated via 'boxcox'}

\item{percentile}{The percentile (ranging from >0 to <1)}
}
\value{
the predicted raw value
}
\description{
In addition of the numeric solution to the regression function on 'predictRaw', this function
can be used retrieving the raw values at a specific age via the parametric box cox power
transformation. Please provide the box cox parameters retrieved via the 'boxcox'-function and
a percentile.
}
\examples{
# model sample data set
model <- bestModel(prepareData())

# fitting scores of regression model box cox power function at specific age and retrieving
# the parameters for the box cox power function
bcParameters <- boxcox(model, 3)

# define percentile and according t value
percentile <- .4
tValue <- qnorm(percentile)*10 + 50

# predict raw value based on the regression model and via box cox
predictRawBC(bcParameters, percentile)
predictRaw(tValue, 3, model$coefficients)
}
\references{
Cole, T. J., & Green, P. J. (1992). Smoothing reference percentile curves: the LMS method and penalized
likelihood. Statistics in medicine, 11(10), 1305-1319.

Box, G. E., & Cox, D. R. (1964). An analysis of transformations. Journal of the Royal Statistical
Society. Series B (Methodological), 211-252.
}
\seealso{
boxcox, predictRaw
}
