% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_check.R
\name{ZoteroCheck}
\alias{ZoteroCheck}
\title{Check Zotero library for duplicates}
\usage{
ZoteroCheck(
  data,
  id,
  id.type,
  created,
  last.modified,
  zotero = NULL,
  silent = FALSE,
  log = list()
)
}
\arguments{
\item{data}{Tibble containing metadata (from Cristin)}

\item{id}{column containing identifier (e.g., cristin_result_id)}

\item{id.type}{Type of metadata as found in the Zotero extra field ("e.g.,
Cristin)}

\item{created}{column containing creation date in UNIX timestamp format
(e.g., created)}

\item{last.modified}{column containing modification date in UNIX timestamp
format (e.g., last_modified)}

\item{zotero}{A list with information on the specified Zotero library (e.g.,
id, API key, collections, and items), Default: NULL}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}

\item{log}{A list for storing log elements, Default: list()}
}
\value{
Returns non-duplicated data in a Zotero-type matrix (tibble)
}
\description{
Remove references that are not modified since last added to
  Zotero
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Simple `Cristin` search by id
  cristin.data <- Cristin(
    id = "840998",
    zotero.import = FALSE
  )

  # Simple `ZoteroCheck`
  example <- ZoteroCheck(
    data = cristin.data$result,
    id = "cristin_result_id",
    id.type = "Cristin",
    created = "created",
    last.modified = "last_modified",
    zotero = Zotero(
      user = FALSE,
      id = "4827927",
      api = "RqlAmlH5l1KPghfCseAq1sQ1",
      library = TRUE,
      silent = TRUE
    )
  )
}
}
\seealso{
\code{\link[dplyr]{arrange}},
 \code{\link[dplyr]{coalesce}},
 \code{\link[dplyr]{bind_rows}},
 \code{\link[dplyr]{filter}}
}
