% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.R, R/print-bvharspec.R
\name{init_ssvs}
\alias{init_ssvs}
\alias{print.ssvsinit}
\alias{knit_print.ssvsinit}
\title{Initial Parameters of Stochastic Search Variable Selection (SSVS) Model}
\usage{
init_ssvs(
  init_coef,
  init_coef_dummy,
  init_chol,
  init_chol_dummy,
  type = c("user", "auto")
)

\method{print}{ssvsinit}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{ssvsinit}(x, ...)
}
\arguments{
\item{init_coef}{Initial coefficient matrix. Initialize with an array or list for multiple chains.}

\item{init_coef_dummy}{Initial indicator matrix (1-0) corresponding to each component of coefficient. Initialize with an array or list for multiple chains.}

\item{init_chol}{Initial cholesky factor (upper triangular). Initialize with an array or list for multiple chains.}

\item{init_chol_dummy}{Initial indicator matrix (1-0) corresponding to each component of cholesky factor. Initialize with an array or list for multiple chains.}

\item{type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Type to choose initial values. One of \code{"user"} (User-given) and \code{"auto"} (OLS for coefficients and 1 for dummy).}

\item{x}{\code{ssvsinit}}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{ssvsinit} object
}
\description{
Set initial parameters before starting Gibbs sampler for SSVS.
}
\details{
Set SSVS initialization for the VAR model.
\itemize{
\item \code{init_coef}: (kp + 1) x m \eqn{A} coefficient matrix.
\item \code{init_coef_dummy}: kp x m \eqn{\Gamma} dummy matrix to restrict the coefficients.
\item \code{init_chol}: k x k \eqn{\Psi} upper triangular cholesky factor, which \eqn{\Psi \Psi^\intercal = \Sigma_e^{-1}}.
\item \code{init_chol_dummy}: k x k \eqn{\Omega} upper triangular dummy matrix to restrict the cholesky factor.
}

Denote that \code{init_chol} and \code{init_chol_dummy} should be upper_triangular or the function gives error.

For parallel chain initialization, assign three-dimensional array or three-length list.
}
\references{
George, E. I., & McCulloch, R. E. (1993). \emph{Variable Selection via Gibbs Sampling}. Journal of the American Statistical Association, 88(423), 881–889.

George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions}. Journal of Econometrics, 142(1), 553–580.

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267–358.
}
