% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria.R
\name{HQ.varlse}
\alias{HQ.varlse}
\alias{HQ.vharlse}
\alias{HQ.bvarmn}
\alias{HQ.bvarflat}
\alias{HQ.bvharmn}
\title{Hannan-Quinn Criterion of Multivariate Time Series Model}
\usage{
\method{HQ}{varlse}(object, ...)

\method{HQ}{vharlse}(object, ...)

\method{HQ}{bvarmn}(object, ...)

\method{HQ}{bvarflat}(object, ...)

\method{HQ}{bvharmn}(object, ...)
}
\arguments{
\item{object}{Model fit}

\item{...}{not used}
}
\value{
HQ value.
}
\description{
Compute HQ of VAR(p), VHAR, BVAR(p), and BVHAR
}
\details{
Let \eqn{\tilde{\Sigma}_e} be the MLE
and let \eqn{\hat{\Sigma}_e} be the unbiased estimator (\code{covmat}) for \eqn{\Sigma_e}.
Note that

\deqn{\tilde{\Sigma}_e = \frac{s - k}{n} \hat{\Sigma}_e}

Then

\deqn{HQ(p) = \log \det \Sigma_e + \frac{2 \log \log s}{s}(\text{number of freely estimated parameters})}

where the number of freely estimated parameters is \eqn{pm^2}.
}
\references{
Hannan, E.J. and Quinn, B.G. (1979). \emph{The Determination of the Order of an Autoregression}. Journal of the Royal Statistical Society: Series B (Methodological), 41: 190-195.

Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.

Quinn, B.G. (1980). \emph{Order Determination for a Multivariate Autoregression}. Journal of the Royal Statistical Society: Series B (Methodological), 42: 182-185.
}
