% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvar-flat.R, R/print-bvarflat.R
\name{bvar_flat}
\alias{bvar_flat}
\alias{print.bvarflat}
\alias{knit_print.bvarflat}
\title{Fitting Bayesian VAR(p) of Flat Prior}
\usage{
bvar_flat(y, p, bayes_spec = set_bvar_flat(), include_mean = TRUE)

\method{print}{bvarflat}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.bvarflat(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{VAR lag}

\item{bayes_spec}{A BVAR model specification by \code{\link[=set_bvar_flat]{set_bvar_flat()}}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{x}{\code{bvarflat} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvar_flat()} returns an object \code{bvarflat} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Posterior Mean matrix of Matrix Normal distribution}
\item{fitted.values}{Fitted values}
\item{residuals}{Residuals}
\item{mn_prec}{Posterior precision matrix of Matrix Normal distribution}
\item{iw_scale}{Posterior scale matrix of posterior inverse-wishart distribution}
\item{iw_shape}{Posterior shape of inverse-wishart distribution}
\item{df}{Numer of Coefficients: mp + 1 or mp}
\item{p}{Lag of VAR}
\item{m}{Dimension of the time series}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{process}{Process string in the \code{bayes_spec}: \code{"BVAR_Flat"}}
\item{spec}{Model specification (\code{bvharspec})}
\item{type}{include constant term (\code{"const"}) or not (\code{"none"})}
\item{call}{Matched call}
\item{prior_mean}{Prior mean matrix of Matrix Normal distribution: zero matrix}
\item{prior_precision}{Prior precision matrix of Matrix Normal distribution: \eqn{U^{-1}}}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input (\code{matrix})}
}
}
\description{
This function fits BVAR(p) with flat prior.
}
\details{
Ghosh et al. (2018) gives flat prior for residual matrix in BVAR.

Under this setting, there are many models such as hierarchical or non-hierarchical.
This function chooses the most simple non-hierarchical matrix normal prior in Section 3.1.

\deqn{A \mid \Sigma_e \sim MN(0, U^{-1}, \Sigma_e)}
where U: precision matrix (MN: \href{https://en.wikipedia.org/wiki/Matrix_normal_distribution}{matrix normal}).
\deqn{p (\Sigma_e) \propto 1}
}
\references{
Ghosh, S., Khare, K., & Michailidis, G. (2018). \emph{High-Dimensional Posterior Consistency in Bayesian Vector Autoregressive Models}. Journal of the American Statistical Association, 114(526).

Litterman, R. B. (1986). \emph{Forecasting with Bayesian Vector Autoregressions: Five Years of Experience}. Journal of Business & Economic Statistics, 4(1), 25.
}
\seealso{
\itemize{
\item \code{\link[=set_bvar_flat]{set_bvar_flat()}} to specify the hyperparameters of BVAR flat prior.
\item \code{\link[=coef.bvarflat]{coef.bvarflat()}}, \code{\link[=residuals.bvarflat]{residuals.bvarflat()}}, and \code{\link[=fitted.bvarflat]{fitted.bvarflat()}}
\item \code{\link[=predict.bvarflat]{predict.bvarflat()}} to forecast the BVHAR process
}
}
