% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvar-horseshoe.R, R/print-bvharsp.R
\name{bvar_horseshoe}
\alias{bvar_horseshoe}
\alias{print.bvarhs}
\alias{knit_print.bvarhs}
\title{Fitting Bayesian VAR(p) of Horseshoe Prior}
\usage{
bvar_horseshoe(
  y,
  p,
  num_chains = 1,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = set_horseshoe(),
  include_mean = TRUE,
  minnesota = FALSE,
  algo = c("block", "gibbs"),
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvarhs}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.bvarhs(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{VAR lag}

\item{num_chains}{Number of MCMC chains}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{Horseshoe initialization specification by \code{\link[=set_horseshoe]{set_horseshoe()}}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Minnesota type}

\item{algo}{Ordinary gibbs sampling (\code{"gibbs"}) or blocked gibbs (Default: \code{"block"}).}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads}

\item{x}{\code{bvarhs} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvar_horseshoe} returns an object named \code{bvarhs} \link{class}.
It is a list with the following components:

\describe{
\item{alpha_record}{MCMC trace for vectorized coefficients (alpha \eqn{\alpha}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{lambda_record}{MCMC trace for local shrinkage level (lambda \eqn{\lambda}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{tau_record}{MCMC trace for global shrinkage level (tau \eqn{\tau}) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{psi_record}{MCMC trace for precision matrix (psi \eqn{\Psi}) with \link{list} format.}
\item{chain}{The numer of chains}
\item{coefficients}{Posterior mean of VAR coefficients.}
\item{psi_posterior}{Posterior mean of precision matrix \eqn{\Psi}}
\item{covmat}{Posterior mean of covariance matrix}
\item{omega_record}{MCMC trace for diagonal element of \eqn{\Psi} (omega) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{eta_record}{MCMC trace for upper triangular element of \eqn{\Psi} (eta) with \link[posterior:draws_df]{posterior::draws_df} format.}
\item{param}{\link[posterior:draws_df]{posterior::draws_df} with every variable: alpha, lambda, tau, omega, and eta}
\item{df}{Numer of Coefficients: \code{mp + 1} or \code{mp}}
\item{p}{Lag of VAR}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Description of the model, e.g. \code{"VAR_Horseshoe"}}
\item{type}{include constant term (\code{"const"}) or not (\code{"none"})}
\item{algo}{Usual Gibbs sampling (\code{"gibbs"}) or fast sampling (\code{"fast"})}
\item{spec}{Horseshoe specification defined by \code{\link[=set_horseshoe]{set_horseshoe()}}}
\item{iter}{Total iterations}
\item{burn}{Burn-in}
\item{thin}{Thinning}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} This function fits BVAR(p) with horseshoe prior.
}
\references{
Carvalho, C. M., Polson, N. G., & Scott, J. G. (2010). \emph{The horseshoe estimator for sparse signals}. Biometrika, 97(2), 465–480.

Makalic, E., & Schmidt, D. F. (2016). \emph{A Simple Sampler for the Horseshoe Estimator}. IEEE Signal Processing Letters, 23(1), 179–182.
}
