% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-param.R
\name{sim_horseshoe_var}
\alias{sim_horseshoe_var}
\alias{sim_horseshoe_vhar}
\title{Generate Horseshoe Parameters}
\usage{
sim_horseshoe_var(
  p,
  dim_data = NULL,
  include_mean = TRUE,
  minnesota = FALSE,
  method = c("eigen", "chol")
)

sim_horseshoe_vhar(
  har = c(5, 22),
  dim_data = NULL,
  include_mean = TRUE,
  minnesota = c("no", "short", "longrun"),
  method = c("eigen", "chol")
)
}
\arguments{
\item{p}{VAR lag}

\item{dim_data}{Specify the dimension of the data if hyperparameters of \code{bayes_spec} have constant values.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Only use off-diagonal terms of each coefficient matrices for restriction.
In \code{sim_horseshoe_var()} function, use \code{TRUE} or \code{FALSE} (default).
In \code{sim_horseshoe_vhar()} function, \code{"no"} (default), \code{"short"} type, or \code{"longrun"} type.}

\item{method}{Method to compute \eqn{\Sigma^{1/2}}.}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}
}
\description{
This function generates parameters of VAR with Horseshoe prior.
}
