% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multnet.R
\name{axe-multnet}
\alias{axe-multnet}
\alias{axe_call.multnet}
\title{Axing an multnet.}
\usage{
\method{axe_call}{multnet}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed multnet object.
}
\description{
multnet objects are created from carrying out multinomial regression
in the \pkg{glmnet} package.
}
\examples{
# Load libraries
suppressWarnings(suppressMessages(library(parsnip)))
suppressWarnings(suppressMessages(library(glmnet)))

# Load data
set.seed(1234)
predictrs <- matrix(rnorm(100*20), ncol = 20)
response <- as.factor(sample(1:4, 100, replace = TRUE))

# Create model and fi
multnet_fit <- multinom_reg() \%>\%
  set_engine("glmnet") \%>\%
  fit_xy(x = predictrs, y = response)

out <- butcher(multnet_fit, verbose = TRUE)

# Another multnet object
fit <- glmnet(predictrs, response, family = "multinomial")
out2 <- butcher(fit, verbose = TRUE)

# Same predictions
newdata <- matrix(rnorm(100*3), ncol = 20)
original_prediction <- predict(fit, newdata)
butchered_prediction <- predict(out2, newdata)
identical(original_prediction,
          butchered_prediction)

}
