% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{composite}
\alias{composite}
\title{Composite fire events in fhx object}
\usage{
composite(
  x,
  filter_prop = 0.25,
  filter_min_rec = 2,
  filter_min_events = 1,
  injury_event = FALSE,
  comp_name = "COMP"
)
}
\arguments{
\item{x}{An \code{fhx} object.}

\item{filter_prop}{The minimum proportion of fire events in recording series
needed for fire event to be considered for composite. Default is 0.25.}

\item{filter_min_rec}{The minimum number of recording series needed for a
fire event to be considered for the composite. Default is 2 recording
series.}

\item{filter_min_events}{The minimum number of fire scars needed for a fire
event to be considered for the composite. Default is 1. Fire injuries are
included in this count if \code{injury_event}  is \code{TRUE}.}

\item{injury_event}{Boolean indicating whether injuries should be considered
events. Default is \code{FALSE}.}

\item{comp_name}{Character vector of the series name for the returned \code{fhx}
object composite series. Default is 'COMP'.}
}
\value{
An \code{fhx} object representing the composited series. The object will
be empty if there are nocomposite-worthy events.
}
\description{
Composite fire events in fhx object
}
\examples{
data(lgr2)
plot(composite(lgr2))

# Use with composite to get composite years:
comp <- composite(pgm, comp_name = "pgm")
event_yrs <- get_event_years(comp)[["pgm"]]
print(event_yrs)

}
\seealso{
\itemize{
\item \code{\link[=intervals]{intervals()}} fire interval analysis from an \code{fhx} composite.
\item \code{\link[=sea]{sea()}} superposed epoch analysis.
\item \code{\link[=series_stats]{series_stats()}} basic summary stats for an \code{fhx} object.
\item \code{\link[=get_event_years]{get_event_years()}} gets years for various events in an \code{fhx} object.
\item \code{\link[=count_event_position]{count_event_position()}} count the number of different events in an \code{fhx}
object.
\item \code{\link[=yearly_recording]{yearly_recording()}} count the number of "recording" events in each year
of an \code{fhx} object.
\item \code{\link[=fhx]{fhx()}} constructs an \code{fhx} object.
\item \code{\link[=as_fhx]{as_fhx()}} casts data frame-like object into an \code{fhx} object.
}
}
