% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sea.R
\name{run_sea}
\alias{run_sea}
\title{Perform superposed epoch analysis.}
\usage{
run_sea(x, key, years_before = 6, years_after = 4, key_period = TRUE,
  n_iter = 1000)
}
\arguments{
\item{x}{A data.frame climate reconstruction or tree-ring series with row names as years.}

\item{key}{A vector of event years for superposed epoch, such as fire years, or an fhx object
with a single \code{series} as produced by \code{composite}}

\item{years_before}{The number of lag years prior to the event year}

\item{years_after}{The number of lag years following the event year}

\item{key_period}{Logical. Constrains the time series to the time period of key events within the range
of the x climate series. False uses the entire climate series, ignoring the period of key events.
time series}

\item{n_iter}{The number of iterations for bootstrap resampling}
}
\description{
Perform superposed epoch analysis.
}
\details{
This function, 'run_sea', is a development version of burnr::sea and has been depreciated. Please use \code{sea}.
}
