% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{site_stats}
\alias{site_stats}
\title{Generate site-level summary statistics}
\usage{
site_stats(x, site_name = "XXX", year_range = NULL, filter_prop = 0.25,
  filter_min_rec = 2, filter_min_events = 1, injury_event = FALSE)
}
\arguments{
\item{x}{An fhx object}

\item{site_name}{Three character site code, defaults to "XXX"}

\item{year_range}{Delimits the analysis period. For example, \code{c(1600, 1900)}.}

\item{filter_prop}{An optional argument if the user chooses to include a composite rug in their plot. This is passed to \code{composite}. See this function for details.}

\item{filter_min_rec}{An optional argument if the user chooses to include a composite rug in their plot. This is passed to \code{composite}. See this function for details.}

\item{filter_min_events}{An optional argument if the user chooses to include a composite rug in their plot. This is passed to \code{composite}. See this function for details.}

\item{injury_event}{Boolean indicating whether injuries should be considered recorders. This is passed to \code{composite}. See this function for details.}
}
\value{
A data.frame of summary statistics
}
\description{
Generate site-level summary statistics
}
\details{
This function produces a summary table for any fhx object. The statistics it includes are shared by other popular fire history software such as FHX2 and FHAES.
}
