% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_event_years}
\alias{get_event_years}
\title{Get years with events for an fhx object.}
\usage{
get_event_years(x, scar_event = TRUE, injury_event = FALSE,
  custom_grep_str = NULL)
}
\arguments{
\item{x}{An \code{fhx} object.}

\item{scar_event}{Boolean indicating whether years with scar events should be returned. Default is TRUE.}

\item{injury_event}{Boolean indicating weather years with injury events should be returned. Default is FALSE.}

\item{custom_grep_str}{Character string to pass a custom grep search pattern to search rec_type column for. Undefined by default.}
}
\value{
A list. Elements of the list are integer vectors giving the years with events for each fhx series. Each element's name reflects the series name.
}
\description{
Get years with events for an fhx object.
}
\examples{
data(pgm)
get_event_years(pgm, scar_event = TRUE, injury_event = TRUE)

# Passing a custom string to grep. This one identified recorder years:
get_event_years(pgm, custom_grep_str = 'recorder_')

# Use with composite to get composite years:
comp <- composite(pgm, comp_name = 'pgm')
event_yrs <- get_event_years(comp)[['pgm']]
print(event_yrs)

}

