% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_zoll.R
\name{zoll_kurse}
\alias{zoll_kurse}
\title{Get exchange rates for customs calculations}
\usage{
zoll_kurse(last_modified_date = NULL, safe = TRUE, refresh = FALSE)
}
\arguments{
\item{last_modified_date}{Optional datetime to retrieve only changes after
this date (format: "YYYY-MM-DD" or "YYYY-MM-DDTHH:MM:SS").}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with exchange rate data.
}
\description{
Get exchange rates for customs calculations
}
\details{
The Zoll API provides import tariff and exchange rate data from the German
Federal Ministry of Finance. This function returns currency exchange rates
used for customs calculations.
Official docs: https://zoll.api.bund.dev.
}
\examples{
\dontrun{
zoll_kurse()
}

}
\seealso{
\code{\link[=zoll_produkte]{zoll_produkte()}} for product tariffs,
\code{\link[=zoll_laender]{zoll_laender()}} for country data.
}
