% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_equalizer.R
\name{util_equalizer}
\alias{util_equalizer}
\title{Calculating distance between utility at tangency and at notch/kink point}
\usage{
util_equalizer(n, elas, t1, t2, Tax, zstar)
}
\arguments{
\item{n}{Ability of person (earnings with zero tax)}

\item{elas}{elasticity of earnings w.r.t.  net-of-tax rate}

\item{t1}{Tax rate before notch/kink}

\item{t2}{Tax rate after notch/kink}

\item{Tax}{height of notch (zero for pure kink)}

\item{zstar}{place of notch/kink (critical earning point)}
}
\value{
Absolute value of utility at tangency minus utility at kink/notch
point.
}
\description{
Ability (n) and elasticity (e) determine an agent's earnings and utility. This
function determines the tangency point of the agent's utility with the budget
line and returns the distance between the utility of earning at that point
and the utility of earning at the notch/kink point. This function is mostly
used to find the marginal buncher.
}
\examples{
util_equalizer(1200,0.2,0.1,0.3,100,1000)

}
\seealso{
\code{\link{util_calc}}
}

