% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kink_estimator.R
\name{kink_estimator}
\alias{kink_estimator}
\title{Analyzing Bunching at a Kink}
\usage{
kink_estimator(earnings, zstar, t1, t2, cf_start = NA, cf_end = NA,
  exclude_before = 2, exclude_after = 2, binw = 10, poly_size = 7,
  convergence = 0.01, max_iter = 100, correct = TRUE, select = TRUE,
  draw = TRUE)
}
\arguments{
\item{earnings}{Vector of earnings, hopefully a very large one.}

\item{zstar}{Place of kink (critical earning point).}

\item{t1}{Marginal tax rate before kink.}

\item{t2}{Marginal tax rate after kink.}

\item{cf_start}{Number of bins before the kink bin where counter-factual
histogram should start.}

\item{cf_end}{Number of bins after the kink bin where counter-factual
histogram should start.}

\item{exclude_before}{Number of excluded bins before the kink bin.}

\item{exclude_after}{Number of excluded bins after the kink bin.}

\item{binw}{Bin width.}

\item{poly_size}{Order of polynomial used to calculate counter-factual
histogram.}

\item{convergence}{Minimal rate of change of bunching estimate to stop
iterations.}

\item{max_iter}{Maximum number of iterations for bunching estimates.}

\item{correct}{Should the counter-factual histogram be corrected to compensate
for shifting left because of the notch? See details.}

\item{select}{Should model selection be used to find counter-factual
histogram? See details.}

\item{draw}{Should a graph be drawn?}
}
\value{
\code{kink_estimator} returns a list of the following variables:
\describe{
  \item{\code{e}}{Estimated elasticity}
  \item{\code{Bn}}{The sum of total estimated extra bunching in the excluded
  bins}
  \item{\code{b}}{The rate of extra bunching in the excluded area, divided by
  the length of area in \$}
  \item{\code{data}}{A data frame with bin mids, counts, counter-factual
  counts, and excluded dummy}
}
}
\description{
Given a kinked budget set, this function gets a vector of earnings and
analyzes bunching. This function could be run independently, but best used
through the \code{bunch} function.
}
\details{
A histogram is created from the earnings vector, with the kink
point zstar as the center of one of the bins.

Correction of the counter-factual is required, as the kink-induced bunching
will shift the whole distribution on the right side of the kink to the left.
This option follows Chetty \emph{et al} (2009) in correcting for this.

Model selection works using the \code{step} function from the stats package.
It runs backwards from the full polynomial model, trying to find the best
explanatory model using the Akaike information criterion.
}
\examples{
ability_vec <- 4000 * rbeta(100000, 2, 5)
earning_vec <- sapply(ability_vec, earning_fun, 0.2, 0, 0.2, 0, 1000)
# bunch_viewer(earning_vec, 1000, 40, 40, 1, 1, binw = 10)
kink_estimator(earning_vec, 1000, 0, 0.2, 40, 40, 1, 1, 10, draw = FALSE)$e

}
\references{
Chetty, R., Friedman, J., Olsen, T., Pistaferri, L. (2009)
\emph{Adjustment Costs, Firm Responses, and Micro vs. Macro Labor Supply
Elasticities: Evidence from Danish Tax Records}, Quarterly Journal of
 Economics, 126(2).
}
\seealso{
\code{\link{bunch}}, \code{\link{notch_estimator}}
}

