% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_buncher.R
\name{marginal_buncher}
\alias{marginal_buncher}
\title{Marginal Buncher}
\usage{
marginal_buncher(beta, binwidth, zstar, notch = FALSE, alpha = NULL)
}
\arguments{
\item{beta}{normalized excess mass.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{zstar}{a numeric value for the the bunching point.}

\item{notch}{whether analysis is for a kink or notch. Default is FALSE (kink).}

\item{alpha}{the proportion of individuals in dominated region (in notch setting).}
}
\value{
\code{marginal_buncher} returns the location of the marginal buncher, i.e. zstar + Dzstar.
}
\description{
Calculate location (value of z_vector) of marginal buncher.
}
\examples{
marginal_buncher(beta = 2, binwidth = 50, zstar = 10000)
}
\seealso{
\code{\link{bunchit}}
}
