% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colony-growth.R
\name{brkpt}
\alias{brkpt}
\title{Fit breakpoint model to individual colony}
\usage{
brkpt(data, t, formula, family = gaussian(link = "log"), ...)
}
\arguments{
\item{data}{a dataframe or tibble}

\item{t}{the unquoted column name for the time variable in \code{data}}

\item{formula}{a formula passed to \code{\link[=glm]{glm()}} or \code{\link[MASS:glm.nb]{MASS::glm.nb()}}.  This should
include the time variable supplied to \code{t}}

\item{family}{a description of the error distribution and link function.
This is passed to \code{\link[=glm]{glm()}} except in the case of \code{family = "negbin"}, which
causes \code{\link[MASS:glm.nb]{MASS::glm.nb()}} to be used to fit a negative binomial GLM.}

\item{...}{additional arguments passed to \code{\link[=glm]{glm()}} or \code{\link[=glm.nb]{glm.nb()}}}
}
\value{
a tibble with a column for the winning tau and a column for the
winning model
}
\description{
Fits models using a range of taus and picks the best one using maximum
likelihood. Typically only used internally by \code{\link[=bumbl]{bumbl()}}.
}
\seealso{
\code{\link[=bumbl]{bumbl()}}
}
\keyword{internal}
