% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternFuns.R
\name{make_heatmap_matrix}
\alias{make_heatmap_matrix}
\title{Create a matrix of the average expression of each gene in each condition}
\usage{
make_heatmap_matrix(tbl, genes = NULL)
}
\arguments{
\item{tbl}{the output of \code{\link{calculate_condition_mean_sd_per_gene}}}

\item{genes}{gene names to use for the output; if NULL (the default),
all genes will be used}
}
\value{
A matrix of averaged expression per gene in each condition.
}
\description{
This function reshapes the tibble output of
\code{\link{calculate_condition_mean_sd_per_gene}} into a matrix of
average expression by condition. Its output can be used by
\code{\link{expression_heatmap}}.
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500,]

condition <- factor(rep(c("0h", "12h", "36h"), each = 2))
tbl <- calculate_condition_mean_sd_per_gene(expression.matrix.preproc[1:10, ], condition)
heatmat <- make_heatmap_matrix(tbl)
heatmat
}
