% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRNpanel.R
\name{GRNpanel}
\alias{GRNpanel}
\alias{GRNpanelUI}
\alias{GRNpanelServer}
\title{Generate the GRN panel of the shiny app}
\usage{
GRNpanelUI(id)

GRNpanelServer(id, expression.matrix, anno, seed = 13)
}
\arguments{
\item{id}{the input slot that will be used to access the value}

\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}}

\item{anno}{annotation data frame containing a match between the row names
of the expression.matrix (usually ENSEMBL IDs) and the gene names that
should be rendered within the app and in output files; this object is
created by \code{\link{generateShinyApp}} using the org.db specified}

\item{seed}{the random seed to be set when running GRN inference, to ensure
reproducibility of GENIE3 outputs}
}
\value{
The UI and Server components of the shiny module, that can be used
within the UI and Server definitions of a shiny app.
}
\description{
These are the UI and server components of the GRN panel of the
shiny app. It is generated by including 'GRN' in the panels.default argument
of \code{\link{generateShinyApp}}.
}
