% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btergm.R
\docType{class}
\name{btergm-class}
\alias{btergm-class}
\alias{show,btergm-method}
\alias{coef,btergm-method}
\alias{nobs,btergm-method}
\alias{btergm.se}
\alias{confint,btergm-method}
\alias{timesteps.btergm}
\alias{summary,btergm-method}
\title{An S4 class to represent a fitted TERGM by bootstrapped MPLE}
\usage{
\S4method{show}{btergm}(object)

\S4method{coef}{btergm}(object, invlogit = FALSE, ...)

\S4method{nobs}{btergm}(object)

btergm.se(object, print = FALSE)

\S4method{confint}{btergm}(object, parm, level = 0.95, type = "perc", invlogit = FALSE, ...)

timesteps.btergm(object)

\S4method{summary}{btergm}(object, level = 0.95, type = "perc", invlogit = FALSE, ...)
}
\arguments{
\item{object}{A \code{btergm} object.}

\item{invlogit}{Apply inverse logit transformation to the estimates and/or
confidence intervals? That is, \eqn{\frac{1}{1 + \exp(-x)}}, where \eqn{x}
is the respective value.}

\item{...}{Further arguments to be passed through to the \code{confint}
function.}

\item{print}{Should the formatted coefficient table be printed to the R
console along with significance stars (\code{print = TRUE}), or should the
plain coefficient matrix be returned (\code{print = FALSE})?}

\item{parm}{Parameters (specified by integer position or character string).}

\item{level}{The significance level for computation of the confidence
intervals. The default is \code{0.95} (that is, an alpha value of 0.05).
Other common values include \code{0.999}, \code{0.99}, and \code{0.9}.}

\item{type}{Type of confidence interval, e.g., basic bootstrap interval
(\code{type = "basic"}), percentile-based interval (\code{type = "perc"},
which is the default option), or bias-adjusted and accelerated confidence
interval (\code{type = "bca"}). All options from the \code{type} argument
of the \link[boot]{boot.ci} function in the boot package can be used to
generate confidence intervals.}
}
\description{
An S4 class to represent a fitted TERGM by bootstrapped MPLE.

Show the coefficients of a \code{btergm} object.
}
\details{
\code{btergm} objects result from the estimation of a bootstrapped TERGM via
the \code{\link{btergm}} function. \code{btergm} objects contain the
coefficients, the bootstrapping samples of the coefficients, the number of
replications, the number of observations, the number of time steps, the
original formula, and the response, effects and weights objects that were fed
into the \code{glm} call for estimating the model.
}
\section{Functions}{
\itemize{
\item \code{coef(btergm)}: Return the coefficients of a \code{btergm} object.

\item \code{nobs(btergm)}: Return the number of observations saved in a
\code{btergm} object.

\item \code{btergm.se()}: Create a coefficient table from a \code{btergm}
  object

Create a coefficient matrix with standard errors and p-values.

This function can create a coefficient matrix with coefficients, standard
errors, z-scores, and p-values, based on a fitted \code{btergm} object.
If the argument \code{print = TRUE} is used, the matrix is printed to the R
console as a formatted coefficient matrix with significance stars instead.
Note that confidence intervals are the preferred way of interpretation for
bootstrapped TERGMs; standard errors are only accurate if the bootstrapped
data are normally distributed, which is not always the case. Various methods
for checking for normality for each model term are available, for example
quantile-quantile plots (e.g., \code{qqnorm(x@boot$t[, 1])} for the first
model term in the \code{btergm} object called \code{x}).

\item \code{confint(btergm)}: Return the confidence intervals for estimates in a
\code{btergm} object.

\item \code{timesteps.btergm()}: Return the number of time steps saved in a
\code{btergm} object.

\item \code{summary(btergm)}: Summary of a fitted \code{btergm} object.

}}
\section{Slots}{

\describe{
\item{\code{coef}}{Object of class \code{"numeric"}. The coefficients.}

\item{\code{boot}}{Object of class \code{"matrix"}. The bootstrapping sample.}

\item{\code{R}}{Object of class \code{"numeric"}. Number of replications.}

\item{\code{nobs}}{Object of class \code{"numeric"}. Number of observations.}

\item{\code{time.steps}}{Object of class \code{"numeric"}. Number of time steps.}

\item{\code{formula}}{Object of class \code{"formula"}. The original model formula
(without indices for the time steps).}

\item{\code{formula2}}{The revised formula with the object references after applying
the \code{\link{tergmprepare}} function.}

\item{\code{response}}{Object of class \code{"integer"}. The response variable.}

\item{\code{effects}}{Object of class \code{"data.frame"}. The effects that went
into the \code{glm} call.}

\item{\code{weights}}{Object of class \code{"integer"}. The weights of the
observations.}

\item{\code{auto.adjust}}{Object of class \code{"logical"}. Indicates whether
automatic adjustment of dimensions was done before estimation.}

\item{\code{offset}}{Object of class \code{"logical"}. Indicates whether an offset
matrix with structural zeros was used.}

\item{\code{directed}}{Object of class \code{"logical"}. Are the dependent networks
directed?}

\item{\code{bipartite}}{Object of class \code{"logical"}. Are the dependent networks
bipartite?}

\item{\code{nvertices}}{Number of vertices.}

\item{\code{data}}{The data after processing by the \code{\link{tergmprepare}}
function.}
}}

\seealso{
Other tergm-classes: 
\code{\link{createBtergm}()},
\code{\link{createMtergm}()},
\code{\link{createTbergm}()},
\code{\link{mtergm-class}},
\code{\link{tbergm-class}}
}
\concept{tergm-classes}
