% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.R
\name{gaussian_approx}
\alias{gaussian_approx}
\alias{gaussian_approx.nongaussian}
\alias{gaussian_approx.ssm_nlg}
\title{Gaussian Approximation of Non-Gaussian/Non-linear State Space Model}
\usage{
gaussian_approx(model, max_iter, conv_tol, ...)

\method{gaussian_approx}{nongaussian}(model, max_iter = 100, conv_tol = 1e-08, ...)

\method{gaussian_approx}{ssm_nlg}(model, max_iter = 100, conv_tol = 1e-08, iekf_iter = 0, ...)
}
\arguments{
\item{model}{Model to be approximated. Should be of class 
\code{bsm_ng}, \code{ar1_ng} \code{svm}, 
\code{ssm_ung}, or \code{ssm_mng}, or \code{ssm_nlg}, i.e. non-gaussian or 
non-linear \code{bssm_model}.}

\item{max_iter}{Maximum number of iterations as a positive integer. 
Default is 100 (although typically only few iterations are needed).}

\item{conv_tol}{Positive tolerance parameter. Default is 1e-8. Approximation 
is claimed to be converged when the mean squared difference of the modes of 
is less than \code{conv_tol}.}

\item{...}{Ignored.}

\item{iekf_iter}{For non-linear models, non-negative number of iterations in 
iterated EKF (defaults to 0, i.e. normal EKF). Used only for models of class 
\code{ssm_nlg}.}
}
\value{
Returns linear-Gaussian SSM of class \code{ssm_ulg} or 
\code{ssm_mlg} which has the same conditional mode of p(alpha|y, theta) as 
  the original model.
}
\description{
Returns the approximating Gaussian model which has the same conditional 
mode of p(alpha|y, theta) as the original model. 
This function is rarely needed itself, and is mainly available for 
testing and debugging purposes.
}
\examples{
data("poisson_series")
model <- bsm_ng(y = poisson_series, sd_slope = 0.01, sd_level = 0.1,
  distribution = "poisson")
out <- gaussian_approx(model)
for(i in 1:7)
 cat("Number of iterations used: ", i, ", y[1] = ",
   gaussian_approx(model, max_iter = i, conv_tol = 0)$y[1], "\n", sep ="")
   
}
\references{
Koopman, SJ and Durbin J (2012). Time Series Analysis by State Space 
Methods. Second edition. Oxford: Oxford University Press.

Vihola, M, Helske, J, Franks, J. (2020). Importance sampling type estimators based 
on approximate marginal Markov chain Monte Carlo. 
Scand J Statist. 1-38. https://doi.org/10.1111/sjos.12492
}
