% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_mcmc.R
\name{expand_sample}
\alias{expand_sample}
\title{Expand the Jump Chain representation}
\usage{
expand_sample(x, variable = "theta", times, states, by_states = TRUE)
}
\arguments{
\item{x}{Output from \code{\link{run_mcmc}}.}

\item{variable}{Expand parameters \code{"theta"} or states \code{"states"}.}

\item{times}{Vector of indices. In case of states, 
what time points to expand? Default is all.}

\item{states}{Vector of indices. In case of states, 
what states to expand? Default is all.}

\item{by_states}{If \code{TRUE} (default), return list by states. 
Otherwise by time.}
}
\description{
The MCMC algorithms of \code{bssm} use a jump chain representation where we 
store the accepted values and the number of times we stayed in the current 
value. Although this saves bit memory and is especially convenient for 
IS-corrected  MCMC, sometimes we want to have the usual sample paths. 
Function \code{expand_sample} returns the expanded sample based on the 
counts. Note that for IS-corrected output the expanded 
sample corresponds to the approximate posterior.
}
