% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_smoother.R
\name{sim_smoother}
\alias{sim_smoother}
\alias{sim_smoother.gssm}
\alias{sim_smoother.bsm}
\alias{sim_smoother.ar1}
\alias{sim_smoother.ngssm}
\alias{sim_smoother.ng_bsm}
\alias{sim_smoother.svm}
\alias{sim_smoother.ng_ar1}
\title{Simulation Smoothing}
\usage{
sim_smoother(object, nsim, seed, use_antithetic = FALSE, ...)

\method{sim_smoother}{gssm}(object, nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE, method = "dk", ...)

\method{sim_smoother}{bsm}(object, nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE, method = "dk", ...)

\method{sim_smoother}{ar1}(object, nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE, method = "dk", ...)

\method{sim_smoother}{ngssm}(object, nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE, ...)

\method{sim_smoother}{ng_bsm}(object, nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE, ...)

\method{sim_smoother}{svm}(object, nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE, ...)

\method{sim_smoother}{ng_ar1}(object, nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE, ...)
}
\arguments{
\item{object}{Model object.}

\item{nsim}{Number of independent samples.}

\item{seed}{Seed for the random number generator.}

\item{use_antithetic}{Use an antithetic variable for location. Default is \code{FALSE}. Only used if \code{method} is "dk".}

\item{...}{Ignored.}

\item{method}{If \code{"dk"} (default), use simulation smoothing algorithm by Durbin and Koopman (2002). If \code{"psi"}, use twisted SMC. 
Only used for Gaussian models of class \code{"gssm"}, \code{"bsm"}, and \code{"ar1"}.}
}
\value{
An array containing the generated samples.
}
\description{
Function \code{sim_smoother} performs simulation smoothing i.e. simulates the states
from the conditional distribution \eqn{p(\alpha | y, \theta)}.
}
\details{
For non-Gaussian/non-linear models, the simulation is based on the approximating
Gaussian model.
}
\examples{
model <- bsm(rep(NA, 50), sd_level = uniform(1,0,5), sd_y = uniform(1,0,5))
sim <- sim_smoother(model, 12)
ts.plot(sim[, 1, ])
}
