% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{run_mcmc.ngssm}
\alias{run_mcmc.ngssm}
\alias{run_mcmc.ng_bsm}
\alias{run_mcmc.svm}
\alias{run_mcmc.nlg_ssm}
\title{Bayesian inference of non-Gaussian or non-linear state space models using MCMC}
\usage{
\method{run_mcmc}{ngssm}(object, n_iter, nsim_states, type = "full",
  method = "pm", simulation_method = "psi", const_m = TRUE,
  delayed_acceptance = TRUE, n_burnin = floor(n_iter/2), n_thin = 1,
  gamma = 2/3, target_acceptance = 0.234, S, end_adaptive_phase = TRUE,
  local_approx = TRUE, n_threads = 1, seed = sample(.Machine$integer.max,
  size = 1), max_iter = 100, conv_tol = 1e-08, ...)

\method{run_mcmc}{ng_bsm}(object, n_iter, nsim_states, type = "full",
  method = "pm", simulation_method = "psi", const_m = TRUE,
  delayed_acceptance = TRUE, n_burnin = floor(n_iter/2), n_thin = 1,
  gamma = 2/3, target_acceptance = 0.234, S, end_adaptive_phase = TRUE,
  local_approx = TRUE, n_threads = 1, seed = sample(.Machine$integer.max,
  size = 1), max_iter = 100, conv_tol = 1e-08, ...)

\method{run_mcmc}{svm}(object, n_iter, nsim_states, type = "full",
  method = "pm", simulation_method = "psi", const_m = TRUE,
  delayed_acceptance = TRUE, n_burnin = floor(n_iter/2), n_thin = 1,
  gamma = 2/3, target_acceptance = 0.234, S, end_adaptive_phase = TRUE,
  local_approx = TRUE, n_threads = 1, seed = sample(.Machine$integer.max,
  size = 1), max_iter = 100, conv_tol = 1e-08, ...)

\method{run_mcmc}{nlg_ssm}(object, n_iter, nsim_states, type = "full",
  method = "pm", simulation_method = "psi", const_m = TRUE,
  delayed_acceptance = TRUE, n_burnin = floor(n_iter/2), n_thin = 1,
  gamma = 2/3, target_acceptance = 0.234, S, end_adaptive_phase = TRUE,
  n_threads = 1, seed = sample(.Machine$integer.max, size = 1),
  max_iter = 100, conv_tol = 1e-04, iekf_iter = 0, ...)
}
\arguments{
\item{object}{Model object.}

\item{n_iter}{Number of MCMC iterations.}

\item{nsim_states}{Number of state samples per MCMC iteration. 
If <2, approximate inference based on Gaussian approximation is performed.}

\item{type}{Either \code{"full"} (default), or \code{"summary"}. The
former produces samples of states whereas the latter gives the mean and
variance estimates of the states.}

\item{method}{Whether pseudo-marginal MCMC (\code{"pm"}) (default) or
importance sampling type correction (\code{"isc"}) is used.}

\item{simulation_method}{If \code{"spdk"}, non-sequential importance sampling based
on Gaussian approximation is used. If \code{"bootstrap"}, bootstrap filter
is used, and if \code{"psi"}, psi-auxiliary particle filter is used.}

\item{const_m}{For importance sampling correction method, should a constant number of 
samples be used for each block? Default is \code{TRUE}. See references for details.}

\item{delayed_acceptance}{For pseudo-marginal MCMC, should delayed acceptance based
on the Gaussian approximation be used?}

\item{n_burnin}{Length of the burn-in period which is disregarded from the
results. Defaults to \code{n_iter / 2}.}

\item{n_thin}{Thinning rate. Defaults to 1. Increase for large models in
order to save memory.}

\item{gamma}{Tuning parameter for the adaptation of RAM algorithm. Must be
between 0 and 1 (not checked).}

\item{target_acceptance}{Target acceptance ratio for RAM. Defaults to 0.234.}

\item{S}{Initial value for the lower triangular matrix of RAM
algorithm, so that the covariance matrix of the Gaussian proposal
distribution is \eqn{SS'}.}

\item{end_adaptive_phase}{If \code{TRUE} (default), $S$ is held fixed after the burnin period.}

\item{local_approx}{If \code{TRUE} (default), Gaussian approximation needed for 
importance sampling is performed at each iteration. If false, approximation is updated only 
once at the start of the MCMC. Not used for non-linear models.}

\item{n_threads}{Number of threads for state simulation.}

\item{seed}{Seed for the random number generator.}

\item{max_iter}{Maximum number of iterations used in Gaussian approximation. Used psi-PF.}

\item{conv_tol}{Tolerance parameter used in Gaussian approximation. Used psi-PF.}

\item{...}{Ignored.}

\item{iekf_iter}{If zero (default), first approximation for non-linear 
Gaussian models is obtained from extended Kalman filter. If 
\code{iekf_iter > 0}, iterated extended Kalman filter is used with 
\code{iekf_iter} iterations.}
}
\description{
Methods for posterior inference of states and parameters.
}
