% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{logLik.gssm}
\alias{logLik.gssm}
\alias{logLik.ngssm}
\title{Log-likelihood of the State Space Model}
\usage{
\method{logLik}{gssm}(object, ...)

\method{logLik}{ngssm}(object, nsim_states, method = "psi", seed = 1,
  max_iter = 100, conv_tol = 1e-08, ...)
}
\arguments{
\item{object}{Model object.}

\item{...}{Ignored.}

\item{nsim_states}{Number of samples for importance sampling. If 0, approximate log-likelihood is returned.
See vignette for details.}

\item{method}{Method for computing the log-likelihood of non-Gaussian/non-linear model. 
Method \code{"spdk"} uses the importance sampling approach by 
Shephard and Pitt (1997), and Durbin and Koopman (1997). \code{"psi"} (the default for linear-Gaussian signals) uses psi-auxiliary filter and 
\code{"bsf"} bootstrap filter (default for general non-linear Gaussian models).}

\item{seed}{Seed for the random number generator. Compared to other functions of the package, the
default seed is fixed (as 1) in order to work properly in numerical optimization algorithms.}

\item{max_iter}{Maximum number of iterations.}

\item{conv_tol}{Tolerance parameter.}
}
\description{
Computes the log-likelihood of the state space model of \code{bssm} package.
}
