% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline.R
\name{bcurve}
\alias{bcurve}
\title{nD B-curve governed by (x,y,...) control points.}
\usage{
bcurve(xy, n = 3)
}
\arguments{
\item{xy}{Real matrix of (x,y,...) coordinates, one control point per row.}

\item{n}{Integer scalar, polynomial order of B-spline (3 by default)}
}
\value{
Function of one argument calculating B-curve. The argument is supposed
  to be in [0, 1] interval.
}
\description{
nD B-curve governed by (x,y,...) control points.
}
\details{
The curve will pass by the first and the last points in 'xy'. The tangents at the
  first and last points will coincide with the first and last segments of
  control points. Example of signature is inspired from this \href{https://www.r-bloggers.com/2023/03/little-useless-useful-r-functions-using-xspline-to-create-wacky-signatures/}{blog}.
}
\examples{
  # simulate doctor's signature ;)
  set.seed(71);
  xy=matrix(rnorm(16), ncol=2)
  tp=seq(0,1,len=301)
  doc_signtr=bcurve(xy)
  plot(doc_signtr(tp), t="l", xaxt='n',  yaxt='n', ann=FALSE, frame.plot=FALSE,
      xlim=range(xy[,1]), ylim=range(xy[,2]))
  # see where control points are
  text(xy, labels=seq(nrow(xy)), col=rgb(0, 0, 0, 0.25))
  # join them by segments
  lines(bcurve(xy, n=1)(tp), col=rgb(0, 0, 1, 0.25))
  
  # randomly curved wire in 3D space
\dontrun{
  if (requireNamespace("rgl", quite=TRUE)) {
     xyz=matrix(rnorm(24),ncol=3)
     tp=seq(0,1,len=201)
     curv3d=bcurve(xyz)
     rgl::plot3d(curv3d(tp), t="l", decorate=FALSE)
  }
}
}
