% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value-box.R
\name{value_box}
\alias{value_box}
\alias{showcase_left_center}
\alias{showcase_top_right}
\title{Value box}
\usage{
value_box(
  title,
  value,
  ...,
  showcase = NULL,
  showcase_layout = showcase_left_center(),
  full_screen = FALSE,
  theme_color = "primary",
  height = NULL,
  max_height = NULL,
  fill = TRUE,
  class = NULL
)

showcase_left_center(
  width = 0.3,
  max_height = "100px",
  max_height_full_screen = 0.67
)

showcase_top_right(
  width = 0.3,
  max_height = "75px",
  max_height_full_screen = 0.67
)
}
\arguments{
\item{title, value}{A string, number, or \code{\link[htmltools:builder]{htmltools::tag()}} child to display as
the title or value of the value box. The \code{title} appears above the \code{value}.}

\item{...}{Unnamed arguments may be any \code{\link[htmltools:builder]{htmltools::tag()}} children to
display below \code{value}. Named arguments become attributes on the containing
element.}

\item{showcase}{A \code{\link[htmltools:builder]{htmltools::tag()}} child to showcase (e.g., a
\code{\link[bsicons:bs_icon]{bsicons::bs_icon()}}, a \code{plotly::plotlyOutput()}, etc).}

\item{showcase_layout}{either \code{showcase_left_center()} or
\code{showcase_top_right()}.}

\item{full_screen}{If \code{TRUE}, an icon will appear when hovering over the card
body. Clicking the icon expands the card to fit viewport size.}

\item{theme_color}{A theme color to use for the background color. Should
match a name in the Bootstrap Sass variable \verb{$theme-colors} (e.g.,
\code{"secondary"}, \code{"success"}, \code{"danger"}, etc).}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{height} in \code{\link[=card_body]{card_body()}}).}

\item{max_height, max_height_full_screen}{A proportion (i.e., a number between
0 and 1) or any valid \link[htmltools:validateCssUnit]{CSS unit} defining the
showcase max_height.}

\item{fill}{Whether to allow the value box to grow/shrink to fit a fillable
container with an opinionated height (e.g., \code{page_fillable()}).}

\item{class}{Utility classes for customizing the appearance of the summary
card. Use \verb{bg-*} and \verb{text-*} classes (e.g, \code{"bg-danger"} and
\code{"text-light"}) to customize the background/foreground colors.}

\item{width}{one of the following:
\itemize{
\item A proportion (i.e., a number between 0 and 1) of available width to
allocate to the showcase.
\item A vector of length 2 valid \link[htmltools:validateCssUnit]{CSS unit} defining
the width of each column (for \code{showcase_left_center()} the 1st unit defines
the showcase width and for \code{showcase_top_right} the 2nd unit defines the
showcase width). Note that any units supported by the CSS grid
\code{grid-template-columns} property may be used (e.g., \code{fr} units).
}}
}
\description{
An opinionated (\code{\link[=card]{card()}}-powered) box, designed for displaying a \code{value} and
\code{title}. Optionally, a \code{showcase} can provide for context for what the
\code{value} represents (for example, it could hold a \code{\link[bsicons:bs_icon]{bsicons::bs_icon()}}, or
even a \code{\link[shiny:plotOutput]{shiny::plotOutput()}}).
}
\examples{

library(htmltools)

if (interactive()) {
  value_box(
    "KPI Title",
    h1(HTML("$1 <i>Billion</i> Dollars")),
    span(
      bsicons::bs_icon("arrow-up"),
      " 30\% VS PREVIOUS 30 DAYS"
    ),
    showcase = bsicons::bs_icon("piggy-bank"),
    class = "bg-success"
  )
}
}
\seealso{
\code{\link[=card]{card()}}
}
