% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{font_face}
\alias{font_face}
\alias{font_link}
\alias{font_google}
\title{Import web fonts into a \code{\link[=bs_theme]{bs_theme()}}}
\usage{
font_face(
  family,
  src,
  weight = NULL,
  style = NULL,
  display = c("swap", "auto", "block", "fallback", "optional"),
  stretch = NULL,
  variant = NULL,
  unicode_range = NULL
)

font_link(family, href)

font_google(
  family,
  local = TRUE,
  cache = sass_file_cache(dir = cache_context_dir(), max_size = 100 * 1024^2),
  wght = NULL,
  ital = NULL,
  display = c("swap", "auto", "block", "fallback", "optional")
)
}
\arguments{
\item{family}{A character string with a \emph{single} font family name.}

\item{src}{A character vector for the \code{src} \verb{@font-face} property. Beware
that is character strings are taken verbatim, so careful quoting and/or URL
encoding may be required.}

\item{weight}{A character (or numeric) vector for the \code{font-weight}
\verb{@font-face} property.}

\item{style}{A character vector for the \code{font-style} \verb{@font-face} property.}

\item{display}{the \code{font-display} \verb{@font-face} property.}

\item{stretch}{A character vector for the \code{font-stretch} \verb{@font-face}
property.}

\item{variant}{A character vector for the \code{font-variant} \verb{@font-face}
property.}

\item{unicode_range}{A character vector for \code{unicode-range} \verb{@font-face}
property.}

\item{href}{A URL resource pointing to the font data.}

\item{local}{Whether or not download and bundle local (woff) font files.}

\item{cache}{A \code{\link[sass:sass_file_cache]{sass::sass_file_cache()}} object (or, more generally, a file
caching class with \verb{$get_file()} and \verb{$set_file()} methods). Set this
argument to \code{FALSE} or \code{NULL} to disable caching.}

\item{wght}{One of the following:
\itemize{
\item \code{NULL}, the default weight for the \code{family}.
\item A character string defining an \href{https://developers.google.com/fonts/docs/css2#axis_ranges}{axis range}
\item A numeric vector of desired font weight(s).
}}

\item{ital}{One of the following:
\itemize{
\item \code{NULL}, the default \code{font-style} for the \code{family}.
\item \code{0}, meaning \code{font-style: normal}
\item \code{1}, meaning \code{font-style: italic}
\item \code{c(0, 1)}, meaning both \code{normal} and \code{italic}
}}
}
\value{
a list with a special class.
}
\description{
When used with any of the main font settings in \code{\link[=bs_theme]{bs_theme()}} (e.g.,
\code{base_font}, \code{code_font}, \code{heading_font}), these font objects ensure relevant
font file resources are included with the theme. A particular font object should
define an single font \code{family} --- if you need multiple families, a \code{list()} of
font objects may be provided to \code{bs_theme()}.
}
\section{Local fonts}{


With local (i.e., self-hosted) fonts, clients (i.e., end users) can render
fonts without an internet connection. By default, \code{google_font()} will
automatically download, cache, and serve font files locally. Non-Google fonts
may also be served locally, but you'll have to download and serve local file
using something like \code{\link[shiny:resourcePaths]{shiny::addResourcePath()}} (or similar) and provide the
relevant files to a \code{\link[=font_face]{font_face()}} definiton.
}

\section{Remote fonts}{


With remotely hosted fonts, clients (i.e., end users) need an internet
connection to render the fonts. Remote fonts can be implemented using
\code{font_google(..., local = FALSE)} (hosted via Google), \code{font_link()} (hosted
via \code{href} URL), or \code{font_face()} (hosted via \code{src} URL).
}

\examples{

# If you have an internet connection, running the following code
# will download, cache, and import the relevant Google Font files
# for local use
theme <- bs_theme(
  base_font = font_google("Fira Sans"),
  code_font = font_google("Fira Code"),
  heading_font = font_google("Fredoka One")
)
if (interactive()) {
  bs_theme_preview(theme)
}

# Three different yet equivalent ways of importing a remotely-hosted Google Font
a <- font_google("Crimson Pro", wght = "200..900", local = FALSE)
b <- font_link(
  "Crimson Pro",
  href = "https://fonts.googleapis.com/css2?family=Crimson+Pro:wght@200..900"
)
url <- "https://fonts.gstatic.com/s/crimsonpro/v13/q5uDsoa5M_tv7IihmnkabARboYF6CsKj.woff2"
c <- font_face(
  family = "Crimson Pro",
  style = "normal",
  weight = "200 900",
  src = paste0("url(", url, ") format('woff2')")
)
theme <- bs_theme(base_font = c)
if (interactive()) {
  bs_theme_preview(theme)
}

}
\references{
\url{https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face}

\url{https://developer.mozilla.org/en-US/docs/Learn/CSS/Styling_text/Web_fonts}

\url{https://developers.google.com/fonts/docs/css2}
}
