% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-remove.R
\name{bs_remove}
\alias{bs_remove}
\alias{bs_retrieve}
\title{Remove or retrieve Sass code from a theme}
\usage{
bs_remove(theme, ids = character(0))

bs_retrieve(theme, ids = character(0), include_unnamed = TRUE)
}
\arguments{
\item{theme}{a \code{\link[=bs_theme]{bs_theme()}} object.}

\item{ids}{a character vector of ids}

\item{include_unnamed}{whether or not to include unnamed \code{\link[sass:sass_layer]{sass::sass_layer()}}s
(e.g., Bootstrap Sass variables, functions, and mixins).}
}
\value{
a modified \code{\link[=bs_theme]{bs_theme()}} object.
}
\description{
Remove or retrieve Sass code from a theme
}
\examples{

# Remove CSS rules for print and carousels
bs_theme(version = 4) \%>\%
  bs_remove(c("_print", "_carousel"))

# Remove BS3 compatibility layer
bs_theme(version = 4) \%>\%
  bs_remove("bs3compat")

}
