% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_delete_wrappers.R
\name{bs_delete_like}
\alias{bs_delete_like}
\alias{bs_unlike}
\title{Delete a like (un-like something)}
\usage{
bs_delete_like(
  rkey,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)

bs_unlike(
  rkey,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{rkey}{Character, length 1. The CID of the version of the record. If not specified, then return the most recent version.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
an \code{httr2} status code
}
\description{
Delete a like (un-like something)
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/follow.json}{graph/list.json (2024-12-03)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/deleteRecord.json}{repo/deleteRecord.json (2024-12-01)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-03)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
like <- bs_like(post = 'https://bsky.app/profile/bskyr.bsky.social/post/3kf2577exva2x')
bs_delete_like(bs_extract_record_key(like$uri))
\dontshow{\}) # examplesIf}
}
\concept{repo}
