% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_follow.R
\name{bs_follow}
\alias{bs_follow}
\title{Follow an account}
\usage{
bs_follow(
  subject,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{subject}{Character, length 1. Subject to act on, as a handle or did.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of follow information
}
\description{
Follow an account
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/follow.json}{graph/list.json (2024-12-02)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2024-12-02)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-02)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_follow(subject = 'chriskenny.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{record}
