% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_draws.R
\name{marginal_draws.bgmfit}
\alias{marginal_draws.bgmfit}
\alias{marginal_draws}
\title{Fitted (expected) values from the posterior draws}
\usage{
\method{marginal_draws}{bgmfit}(
  model,
  resp = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  newdata = NULL,
  datagrid = NULL,
  re_formula = NA,
  allow_new_levels = FALSE,
  sample_new_levels = "gaussian",
  parameter = NULL,
  xrange = 1,
  acg_velocity = 0.1,
  digits = 2,
  numeric_cov_at = NULL,
  aux_variables = NULL,
  levels_id = NULL,
  avg_reffects = NULL,
  idata_method = NULL,
  ipts = NULL,
  seed = 123,
  future = FALSE,
  future_session = "multisession",
  cores = NULL,
  fullframe = FALSE,
  average = FALSE,
  plot = FALSE,
  showlegends = NULL,
  variables = NULL,
  condition = NULL,
  deriv = 0,
  deriv_model = TRUE,
  type = NULL,
  by = NULL,
  conf_level = 0.95,
  transform = NULL,
  byfun = NULL,
  wts = NULL,
  hypothesis = NULL,
  equivalence = NULL,
  reformat = NULL,
  estimate_center = NULL,
  estimate_interval = NULL,
  dummy_to_factor = NULL,
  verbose = FALSE,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

marginal_draws(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{resp}{A character string (default \code{NULL}) to specify response
variable when processing posterior draws for the \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models}

\item{ndraws}{A positive integer indicating the number of posterior draws to
be used in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer indicating the specific posterior draw(s)
to be used in estimation (default \code{NULL}).}

\item{newdata}{An optional data frame to be used in estimation. If
\code{NULL} (default), the \code{newdata} is retrieved from the
\code{model}.}

\item{datagrid}{Generate a grid of user-specified values for use in the
\code{newdata} argument in various functions of the \pkg{marginaleffects}
package. This is useful to define where in the predictor space we want to
evaluate the quantities of interest. See \code{\link[marginaleffects:datagrid]{marginaleffects::datagrid()}} for
details. The default value for the \code{datagrid} is \code{NULL} implying
that no custom grid is constructed. To set a data grid, the argument should
be a data.frame constructed by using the \code{\link[marginaleffects:datagrid]{marginaleffects::datagrid()}}
function, or else a named list which are internally used for setting up the
grid. For the user convenience, we also allow setting an empty list
\code{datagrid = list()} in which case essential arguments such as
\code{model}, \code{newdata} are taken up from the respective arguments
specified elsewhere. Further, the level 1 predictor (such as age) and any
covariate included in the model fit (e.g., gender) are also automatically
inferred from the \code{model} object.}

\item{re_formula}{Option to indicate whether or not to include the
individual/group-level effects in the estimation. When \code{NA} (default),
the individual-level effects are excluded and therefore population average
growth parameters are computed. When \code{NULL}, individual-level effects
are included in the computation and hence the growth parameters estimates
returned are individual-specific. In both situations, (i.e,, \code{NA} or
\code{NULL}), continuous and factor covariate(s) are appropriately included
in the estimation. The continuous covariates by default are set to their
means (see \code{numeric_cov_at} for details) whereas factor covariates are
left unaltered thereby allowing estimation of covariate specific population
average and individual-specific growth parameter.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), each posterior sample for a
new level is drawn from the posterior draws of a randomly chosen existing
level. Each posterior sample for a new level may be drawn from a different
existing level such that the resulting set of new posterior draws
represents the variation across existing levels. If \code{"gaussian"},
sample new levels from the (multivariate) normal distribution implied by the
group-level standard deviations and correlations. This options may be useful
for conducting Bayesian power analysis or predicting new levels in
situations where relatively few levels where observed in the old_data. If
\code{"old_levels"}, directly sample new levels from the existing levels,
where a new level is assigned all of the posterior draws of the same
(randomly chosen) existing level.}

\item{parameter}{A single character string, or a character vector specifying
the growth parameter(s) to be estimated. Options are \code{'tgv'} (takeoff
growth velocity), \code{'atgv'} (age at takeoff growth velocity),
\code{'pgv'} (peak growth velocity), \code{'apgv'} (age at peak growth
velocity), \code{'cgv'} (cessation growth velocity), and \code{'acgv'} (age
at cessation growth velocity), and \code{'all'}. If \code{parameter = NULL}
(default), age at peak growth velocity (\code{'apgv'}) is estimated where
when \code{parameter = 'all'}, all six parameters are estimated. Note that
option \code{'all'} can not be used when argument \code{by} is \code{TRUE}.}

\item{xrange}{An integer to set the predictor range (i.e., age) when
executing the interpolation via \code{ipts}. The default \code{NULL} sets
the individual specific predictor range whereas code \code{xrange = 1} sets
identical range for individuals within the same higher grouping variable
(e.g., study). Code \code{xrange  = 2} sets the identical range across the
entire sample. Lastly, a paired numeric values can be supplied e.g.,
\code{xrange = c(6, 20)} to set the range within those values.}

\item{acg_velocity}{A real number to set the percentage of peak growth growth
velocity as the cessation velocity when estimating the \code{cgv} and
\code{acgv} growth parameters. The \code{acg_velocity} should be greater
than \code{0} and less than \code{1}. The default \code{acg_velocity =
  0.10} indicates that a 10 per cent of the peak growth velocity will be used
to get the cessation velocity and the corresponding age at the cessation
velocity. For example if peak growth velocity estimate is \code{10
  mm/year}, then cessation growth velocity is \code{1 mm/year}.}

\item{digits}{An integer (default \code{2}) to set the decimal argument for
the \code{\link[base:Round]{base::round()}} function.}

\item{numeric_cov_at}{An optional (named list) argument to specify the value
of continuous covariate(s). The default \code{NULL} option set the
continuous covariate(s) at their mean. Alternatively, a named list can be
supplied to manually set these values. For example, \code{numeric_cov_at =
  list(xx = 2)} will set the continuous covariate varibale 'xx' at 2. The
argument \code{numeric_cov_at} is ignored when no continuous covariate is
included in the model.}

\item{aux_variables}{An optional argument to specify the variable(s) that can
be passed to the \code{ipts} argument (see below). This is useful when
fitting location scale models and measurement error models. An
indication to use \code{aux_variables} is when post processing functions
throw an error such as \code{variable 'x' not found either 'data' or
 'data2'}}

\item{levels_id}{An optional argument to specify the \code{ids} for
hierarchical model (default \code{NULL}). It is used only when model is
applied to the data with 3 or more levels of hierarchy. For a two level
model, the \code{levels_id} is automatically inferred from the model fit.
Even for 3 or higher level model, the \code{levels_id} is inferred from the
model fit but under the assumption that hierarchy is specified from lowest
to upper most level i.e, \code{id} followed by \code{study} where \code{id}
is nested within the \code{study} Note that it is not guaranteed that the
\code{levels_id} is sorted correctly, and therefore it is better to set it
manually when fitting a model with three or more levels of hierarchy.}

\item{avg_reffects}{An optional argument (default \code{NULL}) to calculate
(marginal/average) curves and growth parameters such as APGV and PGV. If
specified, it must be a named list indicating the \code{over} (typically
level 1 predictor, such as age), \code{feby} (fixed effects, typically a
factor variable), and  \code{reby} (typically \code{NULL} indicating that
parameters are integrated over the random effects) such as
\code{avg_reffects = list(feby = 'study', reby = NULL, over = 'age')}.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of of interpolation points is set up the \code{ipts} argument.
Options available for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}). The
\emph{method 1} (\code{'m1'}) is adapted from the the \pkg{iapvbs} package
and is documented here
\url{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}
whereas \emph{method 2} (\code{'m2'}) is based on the \pkg{JMbayes}
package as documented here
\url{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}.
The \code{'m1'} method works by internally constructing the data frame based
on the model configuration whereas the method \code{'m2'} uses the exact
data frame used in model fit and can be accessed via \code{fit$data}. If
\code{idata_method = NULL, default}, then method \code{'m2'} is
automatically set. Note that method \code{'m1'} might fail in some cases
when model involves covariates particularly when model is fit as
\code{univariate_by}. Therefore, it is advised to switch to method
\code{'m2'} in case \code{'m1'} results in error.}

\item{ipts}{An integer to set the length of the predictor variable to get a
smooth velocity curve. The \code{NULL} will return original values whereas
an integer such as \code{ipts = 10} (default) will interpolate the
predictor. It is important to note that these interpolations do not alter
the range of predictor when calculating population average and/or the
individual specific growth curves.}

\item{seed}{An integer (default \code{123}) that is passed to the estimation
method.}

\item{future}{A logical (default \code{FALSE}) to specify whether or not to
perform parallel computations. If set to \code{TRUE}, the
\code{\link[future.apply:future_lapply]{future.apply::future_sapply()}} function is used to summarize draws.}

\item{future_session}{A character string to set the session type when
\code{future = TRUE}. The \code{'multisession'} (default) options sets the
multisession whereas the \code{'multicore'} sets the multicore session.
Note that option \code{'multicore'} is not supported on Windows systems.
For more details, see \code{\link[future.apply:future_lapply]{future.apply::future_sapply()}}.}

\item{cores}{Number of cores to be used when running the parallel
computations (if \code{future = TRUE}). On non-Windows systems this
argument can be set globally via the mc.cores option. For the default
\code{NULL} option, the number of cores are set automatically by calling
the \code{\link[future:re-exports]{future::availableCores()}}. The number of cores used are the maximum
number of cores avaialble minus one, i.e., \code{future::availableCores() -
  1}.}

\item{fullframe}{A logical to indicate whether to return \code{fullframe}
object in which \code{newdata} is bind to the summary estimates. Note that
\code{fullframe} can not be combined with \code{summary = FALSE}.
Furthermore, \code{fullframe} can only be used when \code{idata_method =
  'm2'}. A particular use case is when fitting \code{univariate_by} model.
The \code{fullframe} is mainly for internal use only.}

\item{average}{A logical to indicate whether to internally call the
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} or the
\code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}} function. If \code{FALSE} (default),
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} is called otherwise
\code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}} when \code{average = TRUE}.}

\item{plot}{A logical to specify whether to plot predictions by calling the
\code{\link[marginaleffects:plot_predictions]{marginaleffects::plot_predictions()}} function (\code{FALSE}) or not
(\code{FALSE}). If \code{FALSE} (default), then
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}} or \code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}}
are called to compute predictions (see \code{average} for details)}

\item{showlegends}{An argument to specify whether to show legends
(\code{TRUE}) or not (\code{FALSE}). If \code{NULL} (default), then
\code{showlegends} is internally set to \code{TRUE} if \code{re_formula =
  NA}, and \code{FALSE} if \code{re_formula = NULL}.}

\item{variables}{For estimating growth parameters in the current use case,
the \code{variables} is the level 1 predictor such as
\code{age}/\code{time}. The \code{variables} is a named list where value is
set via the \code{esp} argument (default 1e-6). If \code{NULL}, the
\code{variables} is set internally by retrieving the relevant information
from the \code{model}. Otherwise, user can define it as follows:
\code{variables = list('x' = 1e-6)} where \code{'x'} is the level 1
predictor. Note that \code{variables = list('age' = 1e-6)} is the default
behavior for the \pkg{marginaleffects} because velocity is typically
calculated by differentiating the distance curve via \code{dydx} approach,
and therefore argument \code{deriv} is automatically set as \code{0} and
\code{deriv_model} as \code{FALSE}. If user want to estimate parameters
based on the model based first derivative, then argument \code{deriv} must
be set as \code{1} and internally argument \code{variables} is defined as
\code{variables = list('age' = 0)} i.e, original level 1 predictor
variable, \code{'x'}. It is important to consider that if default behavior
is used i.e, \code{deriv = 0} and \code{variables = list('x' = 1e-6)}, then
user can not pass additional arguments to the \code{variables} argument. On
the other hand, alternative approach i.e, \code{deriv = 0} and
\code{variables = list('x' = 0)}, additional options can be passed to the
\code{\link[marginaleffects:comparisons]{marginaleffects::comparisons()}} and \code{\link[marginaleffects:comparisons]{marginaleffects::avg_comparisons()}}
functions.}

\item{condition}{Conditional predictions
\itemize{
\item Character vector (max length 4): Names of the predictors to display.
\item Named list (max length 4): List names correspond to predictors. List elements can be:
\itemize{
\item Numeric vector
\item Function which returns a numeric vector or a set of unique categorical values
\item Shortcut strings for common reference values: "minmax", "quartile", "threenum"
}
\item 1: x-axis. 2: color/shape. 3: facet (wrap if no fourth variable, otherwise cols of grid). 4: facet (rows of grid).
\item Numeric variables in positions 2 and 3 are summarized by Tukey's five numbers \code{?stats::fivenum}
}}

\item{deriv}{An integer to indicate whether to estimate distance curve or its
derivative (i.e., velocity curve). The \code{deriv = 0} (default) is for
the distance curve whereas \code{deriv = 1} for the velocity curve.}

\item{deriv_model}{A logical to specify whether to estimate velocity curve
from the derivative function, or the differentiation of the distance curve.
The argument \code{deriv_model} is set to \code{TRUE} for those functions
which need velocity curve such as \code{growthparameters()} and
\code{plot_curves()}, and \code{NULL} for functions which explicitly use
the distance curve (i.e., fitted values) such as \code{loo_validation()}
and \code{plot_ppc()}.}

\item{type}{string indicates the type (scale) of the predictions used to
compute contrasts or slopes. This can differ based on the model
type, but will typically be a string such as: "response", "link", "probs",
or "zero". When an unsupported string is entered, the model-specific list of
acceptable values is returned in an error message. When \code{type} is \code{NULL}, the
first entry in the error message is used by default.}

\item{by}{Aggregate unit-level estimates (aka, marginalize, average over). Valid inputs:
\itemize{
\item \code{FALSE}: return the original unit-level estimates.
\item \code{TRUE}: aggregate estimates for each term.
\item Character vector of column names in \code{newdata} or in the data frame produced by calling the function without the \code{by} argument.
\item Data frame with a \code{by} column of group labels, and merging columns shared by \code{newdata} or the data frame produced by calling the same function without the \code{by} argument.
\item See examples below.
\item For more complex aggregations, you can use the \code{FUN} argument of the \code{hypotheses()} function. See that function's documentation and the Hypothesis Test vignettes on the \code{marginaleffects} website.
}}

\item{conf_level}{numeric value between 0 and 1. Confidence level to use to build a confidence interval.}

\item{transform}{string or function. Transformation applied to unit-level estimates and confidence intervals just before the function returns results. Functions must accept a vector and return a vector of the same length. Support string shortcuts: "exp", "ln"}

\item{byfun}{A function such as \code{mean()} or \code{sum()} used to aggregate
estimates within the subgroups defined by the \code{by} argument. \code{NULL} uses the
\code{mean()} function. Must accept a numeric vector and return a single numeric
value. This is sometimes used to take the sum or mean of predicted
probabilities across outcome or predictor
levels. See examples section.}

\item{wts}{string or numeric: weights to use when computing average contrasts or slopes. These weights only affect the averaging in \verb{avg_*()} or with the \code{by} argument, and not the unit-level estimates themselves. Internally, estimates and weights are passed to the \code{weighted.mean()} function.
\itemize{
\item string: column name of the weights variable in \code{newdata}. When supplying a column name to \code{wts}, it is recommended to supply the original data (including the weights variable) explicitly to \code{newdata}.
\item numeric: vector of length equal to the number of rows in the original data or in \code{newdata} (if supplied).
}}

\item{hypothesis}{specify a hypothesis test or custom contrast using a numeric value, vector, or matrix, a string, or a string formula.
\itemize{
\item Numeric:
\itemize{
\item Single value: the null hypothesis used in the computation of Z and p (before applying \code{transform}).
\item Vector: Weights to compute a linear combination of (custom contrast between) estimates. Length equal to the number of rows generated by the same function call, but without the \code{hypothesis} argument.
\item Matrix: Each column is a vector of weights, as describe above, used to compute a distinct linear combination of (contrast between) estimates. The column names of the matrix are used as labels in the output.
}
\item String formula to specify linear or non-linear hypothesis tests. If the \code{term} column uniquely identifies rows, terms can be used in the formula. Otherwise, use \code{b1}, \code{b2}, etc. to identify the position of each parameter. The \verb{b*} wildcard can be used to test hypotheses on all estimates. Examples:
\itemize{
\item \code{hp = drat}
\item \code{hp + drat = 12}
\item \code{b1 + b2 + b3 = 0}
\item \verb{b* / b1 = 1}
}
\item String:
\itemize{
\item "pairwise": pairwise differences between estimates in each row.
\item "reference": differences between the estimates in each row and the estimate in the first row.
\item "sequential": difference between an estimate and the estimate in the next row.
\item "revpairwise", "revreference", "revsequential": inverse of the corresponding hypotheses, as described above.
}
\item See the Examples section below and the vignette: https://marginaleffects.com/vignettes/hypothesis.html
}}

\item{equivalence}{Numeric vector of length 2: bounds used for the two-one-sided test (TOST) of equivalence, and for the non-inferiority and non-superiority tests. See Details section below.}

\item{reformat}{A logical (default \code{TRUE}) to reformat the  output
returned by the \code{marginaleffects} as a data.frame with column names
re-defined as follows: \code{conf.low} as \code{Q2.5}, and \code{conf.high}
as \code{Q97.5} (assuming that \code{conf_int = 0.95}). Also, following
columns are dropped from the data frame: \code{term}, \code{contrast},
\code{tmp_idx}, \code{predicted_lo}, \code{predicted_hi}, \code{predicted}.}

\item{estimate_center}{A character string (default \code{NULL}) to specify
whether to center estimate as \code{'mean'} or as \code{'median'}. Note
that \code{estimate_center} is used to set the global options as follows:
\cr
\code{ options("marginaleffects_posterior_center" = "mean")}, or \cr
\code{options("marginaleffects_posterior_center" = "median")} \cr
The pre-specified global options are restored on exit via the
\code{\link[base:on.exit]{base::on.exit()}}.}

\item{estimate_interval}{A character string (default \code{NULL}) to specify
whether to compute credible intervals as equal-tailed intervals,
\code{'eti'} or highest density intervals, \code{'hdi'}. Note that
\code{estimate_interval} is used to set the global options as follows: \cr
\code{ options("marginaleffects_posterior_interval" = "eti")}, or \cr
\code{ options("marginaleffects_posterior_interval" = "hdi")} \cr
The pre-specified global options are restored on exit via the
\code{\link[base:on.exit]{base::on.exit()}}.}

\item{dummy_to_factor}{A named list (default \code{NULL}) that is used to
convert dummy variables into a factor variable. The named elements are
\code{factor.dummy}, \code{factor.name}, and \code{factor.level}. The
\code{factor.dummy} is a vector of character strings that need to be
converted to a factor variable whereas the \code{factor.name} is a single
character string that is used to name the newly created factor variable.
The \code{factor.level} is used to name the levels of newly created factor.
When \code{factor.name} is \code{NULL}, then the factor name is internally
set as \code{'factor.var'}. If \code{factor.level} is \code{NULL}, then
names of factor levels are take from the \code{factor.dummy} i.e., the
factor levels are assigned same name as \code{factor.dummy}. Note that when
\code{factor.level} is not \code{NULL}, its length must be same as the
length of the \code{factor.dummy}.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{expose_function}{An optional logical argument to indicate whether to
expose Stan functions (default \code{FALSE}). Note that if user has already
exposed Stan functions during model fit by setting \code{expose_function =
  TRUE} in the \code{\link[=bsitar]{bsitar()}}, then those exposed functions are saved and can be
used during post processing of the posterior draws and therefore
\code{expose_function} is by default set as \code{FALSE} in all post
processing functions except \code{\link[=optimize_model]{optimize_model()}}. For \code{\link[=optimize_model]{optimize_model()}}, the
default setting is \code{expose_function = NULL}. The reason is that each
optimized model has different Stan function and therefore it need to be re
exposed and saved. The \code{expose_function = NULL} implies that the
setting for \code{expose_function} is taken from the original \code{model}
fit. Note that \code{expose_function} must be set to \code{TRUE} when
adding \code{fit criteria} and/or \code{bayes_R2} during model
optimization.}

\item{usesavedfuns}{A logical (default \code{NULL}) to indicate whether to
use the already exposed and saved \code{Stan} functions. Depending on
whether the user have exposed Stan functions within the \code{\link[=bsitar]{bsitar()}} call via
\code{expose_functions} argument in the \code{\link[=bsitar]{bsitar()}}, the \code{usesavedfuns}
is automatically set to \code{TRUE} (if \code{expose_functions = TRUE}) or
\code{FALSE} (if \code{expose_functions = FALSE}). Therefore, manual
setting of \code{usesavedfuns} as \code{TRUE}/\code{FALSE} is rarely
needed. This is for internal purposes only and mainly used during the
testing of the functions and therefore should not be used by users as it
might lead to unreliable estimates.}

\item{clearenvfuns}{A logical to indicate whether to clear the exposed
function from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL} (default), then \code{clearenvfuns} is set as \code{TRUE} when
\code{usesavedfuns} is \code{TRUE}, and \code{FALSE} if \code{usesavedfuns}
is \code{FALSE}.}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:fitted.brmsfit]{brms::fitted.brmsfit()}}
function. Please see \code{brms::fitted.brmsfit()} for details on
various options available.}
}
\value{
An array of predicted mean response values. See
\link[brms:fitted.brmsfit]{brms::fitted.brmsfit} for details.
}
\description{
The \strong{marginal_draws()} function estimates and plots
growth curves (distance and velocity) by using \pkg{marginaleffects}
package as back-end. This function can compute growth curves (via
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}}), average growth curves (via
\code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}}) or plot growth curves (via
\code{\link[marginaleffects:plot_predictions]{marginaleffects::plot_predictions()}}). Please see
\href{https://marginaleffects.com/}{here} for details.
}
\details{
The \strong{marginal_draws()} estimates fitted values (via
\code{\link[brms:fitted.brmsfit]{brms::fitted.brmsfit()}}) or the posterior draws from the posterior
distribution (via \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}) depending on the \code{type}
argument.
}
\examples{

\donttest{
# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# Population average distance curve
marginal_draws(model, deriv = 0, re_formula = NA)


# Individual-specific distance curves
marginal_draws(model, deriv = 0, re_formula = NULL)

# Population average velocity curve
marginal_draws(model, deriv = 1, re_formula = NA)

# Individual-specific velocity curves
marginal_draws(model, deriv = 1, re_formula = NULL)
}

}
\seealso{
\code{\link[marginaleffects:predictions]{marginaleffects::predictions()}}
\code{\link[marginaleffects:predictions]{marginaleffects::avg_predictions()}}
\code{\link[marginaleffects:plot_predictions]{marginaleffects::plot_predictions()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
