% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R, R/aliases.R
\name{bs4CardLayout}
\alias{bs4CardLayout}
\alias{boxLayout}
\title{Bootstrap 4 container for cards}
\usage{
bs4CardLayout(..., type = c("group", "deck", "columns"))

boxLayout(..., type = c("group", "deck", "columns"))
}
\arguments{
\item{...}{Slot for bs4Dash cards.}

\item{type}{Container type. See \url{https://getbootstrap.com/docs/4.0/components/card/#card-layout}
for more details.}
}
\description{
Bootstrap 4 container for cards

Alias to \link{bs4CardLayout}
See \link{bs4CardLayout} for full details
}
\note{
Cards must have width argument set to NULL.
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  # with group
  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      body = dashboardBody(
        boxLayout(
          type = "group",
          lapply(1:4, function(i) {
            box(
              width = NULL,
              title = paste("Card", i),
              closable = FALSE,
              collapsible = FALSE,
              "Lorem ipsum is so fun!"
            )
          })
        )
      ),
      controlbar = dashboardControlbar(),
      title = "Box layout group"
    ),
    server = function(input, output) {}
  )

  # with deck
  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      body = dashboardBody(
        boxLayout(
          type = "deck",
          lapply(1:4, function(i) {
            box(
              width = NULL,
              title = paste("Card", i),
              closable = FALSE,
              collapsible = FALSE,
              "Lorem ipsum is so fun!"
            )
          })
        )
      ),
      controlbar = dashboardControlbar(),
      title = "Box layout deck"
    ),
    server = function(input, output) {}
  )

  # with columns
  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      body = dashboardBody(
        boxLayout(
          type = "columns",
          lapply(1:12, function(i) {
            box(
              width = NULL,
              title = paste("Card", i),
              closable = FALSE,
              collapsible = FALSE,
              height = if (i \%\% 2 == 1) "200px",
              status = if (i \%\% 2 == 0) "primary",
              if (i \%\% 2 == 0) "Lorem ipsum is so fun!",
              if (i == 1 | i == 7 | i == 12) img(src = "https://via.placeholder.com/290x160")
            )
          })
        )
      ),
      controlbar = dashboardControlbar(),
      title = "Box layout columns"
    ),
    server = function(input, output) {}
  )
}
}
\seealso{
Other cards: 
\code{\link{bs4SocialCard}()},
\code{\link{bs4TabCard}()},
\code{\link{bs4UserCard}()},
\code{\link{descriptionBlock}()},
\code{\link{renderbs4InfoBox}()},
\code{\link{renderbs4ValueBox}()}
}
\concept{cards}
