% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedbacks.R
\name{createAlert}
\alias{createAlert}
\alias{closeAlert}
\title{Create a Bootstrap 4 alert on the server side}
\usage{
createAlert(
  id = NULL,
  selector = NULL,
  options,
  session = shiny::getDefaultReactiveDomain()
)

closeAlert(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{id}{Anchor id.}

\item{selector}{jQuery selector. Allow more customization for the anchor (nested tags).}

\item{options}{List of options to pass to the alert. See below:
\itemize{
 \item content: Alert content.
 \item title: Alert title.
 \item closable: Whether to allow the user to close the alert. FALSE by default.
 \item width: Alert width. Between 1 and 12.
 \item elevation: Alert elevation.
 \item status: Alert status. "primary", "success", "warning", "danger" or "info".
}}

\item{session}{Shiny session object.}
}
\description{
\link{createAlert} creates an alert and inserts it in the DOM.

\link{closeAlert} closes an alert created via \link{createAlert}.
}
\note{
Unlike shinyBS, there is no need to specify an anchorId and an alertId. id refers to the anchorId,
and the alertId is simply "anchorId-alert". On the server side, one can access the alert status by
input$<id>. If TRUE, the alert has been created and is visible, if FALSE the alert has just been closed.
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      body = dashboardBody(
        tooltip(
          sliderInput("obs", "Observations:", 10, min = 1, max = 100),
          placement = "right",
          title = "Set me higher than 50!"
        ),
        div(id = "myalert", style = "position: absolute; bottom: 0; right: 0;")
      ),
      controlbar = dashboardControlbar(),
      title = "Alerts",
    ),
    server = function(input, output, session) {
      observeEvent(input$obs, {
        if (input$obs > 50) {
          createAlert(
            id = "myalert",
            options = list(
              title = "Alert",
              closable = TRUE,
              width = 12,
              elevations = 4,
              status = "primary",
              content = "Alert content ..."
            )
          )
        } else {
          closeAlert(id = "myalert")
        }
      })

      observe(print(input$myalert))

      observeEvent(input$myalert, {
        alertStatus <- if (input$myalert) "opened" else "closed"
        toastColor <- if (input$myalert) "bg-lime" else "bg-fuchsia"
        toast(
          title = sprintf("Alert succesfully \%s!", alertStatus),
          options = list(
            class = toastColor,
            autohide = TRUE,
            position = "topRight"
          )
        )
      })
    }
  )
}
}
