% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-functions.R, R/aliases.R
\name{renderbs4ValueBox}
\alias{renderbs4ValueBox}
\alias{renderbs4InfoBox}
\alias{renderValueBox}
\title{Create a value box (server side)}
\usage{
renderbs4ValueBox(expr, env = parent.frame(), quoted = FALSE)

renderbs4InfoBox(expr, env = parent.frame(), quoted = FALSE)

renderValueBox(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{An expression that returns a Shiny tag object, \code{\link[=HTML]{HTML()}},
or a list of such objects.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
This is the server-side function for creating a dynamic
\code{\link{bs4ValueBox}}.
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      fluidRow(
       bs4ValueBoxOutput("vbox"),
       bs4InfoBoxOutput("ibox")
      )
     )
   ),
   server = function(input, output) {
   
     output$vbox <- renderbs4ValueBox({
      bs4ValueBox(
        value = 150,
        subtitle = "New orders",
        status = "primary",
        icon = "shopping-cart",
        href = "#"
       )
    })
    
    output$ibox <- renderbs4InfoBox({
      bs4InfoBox(
       title = "Comments",
       gradientColor = "success",
       value = 41410,
       icon = "comments"
       )
    })
    
   }
 )
}

}
\seealso{
\code{\link{bs4ValueBoxOutput}} for the corresponding UI-side function.
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
