% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Timeline}
\alias{bs4Timeline}
\title{AdminLTE3 timeline block}
\usage{
bs4Timeline(..., reversed = TRUE, width = 6)
}
\arguments{
\item{...}{slot for \link{bs4TimelineLabel} or \link{bs4TimelineItem}.}

\item{reversed}{Whether the timeline is reversed or not.}

\item{width}{Timeline width. Between 1 and 12.}
}
\description{
Create a timeline block
}
\note{
reversed is useful when the user wants to use the timeline
inside a box.
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shiny::shinyApp(
   ui = bs4DashPage(
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(),
    controlbar = bs4DashControlbar(),
    footer = bs4DashFooter(),
    title = "test",
    body = bs4DashBody(
     bs4Card(
      title = "Timeline",
      bs4Timeline(
       width = 12,
       reversed = TRUE,
       bs4TimelineEnd(status = "danger"),
       bs4TimelineLabel("10 Feb. 2014", status = "info"),
       bs4TimelineItem(
        elevation = 4, 
        title = "Item 1",
        icon = "gears",
        status = "success",
        time = "now",
        footer = "Here is the footer",
        "This is the body"
       ),
       bs4TimelineItem(
        title = "Item 2",
        border = FALSE
       ),
       bs4TimelineLabel("3 Jan. 2014", status = "primary"),
       bs4TimelineItem(
        elevation = 2,
        title = "Item 3",
        icon = "paint-brush",
        status = "warning",
        bs4TimelineItemMedia(src = "http://placehold.it/150x100"),
        bs4TimelineItemMedia(src = "http://placehold.it/150x100")
       ),
       bs4TimelineStart(status = "danger")
      )
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
