% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{bs4UserCard}
\alias{bs4UserCard}
\title{AdminLTE3 widget user card}
\usage{
bs4UserCard(..., type = NULL, src = NULL, elevation = NULL,
  imageElevation = NULL, status = c("primary", "warning", "danger",
  "info", "success"), title = NULL, subtitle = NULL, width = 6)
}
\arguments{
\item{...}{Footer content.}

\item{type}{User card type. Either NULL or 2.}

\item{src}{User image url or path.}

\item{elevation}{User card elevation (numeric). NULL by default.}

\item{imageElevation}{User card image elevation (numeric). NULL by default.}

\item{status}{User card color. "primary", "warning", "danger", "info" or "success".}

\item{title}{User card title.}

\item{subtitle}{User card subtitle.}

\item{width}{The width of the card, using the Bootstrap grid system.}
}
\description{
Create widget user card
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      fluidRow(
      bs4UserCard(
        src = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
        status = "info",
        title = "User card type 1",
        subtitle = "a subtitle here",
        elevation = 4,
        "Any content here"
       ),
       bs4UserCard(
        type = 2,
        src = "https://adminlte.io/themes/AdminLTE/dist/img/user7-128x128.jpg",
        status = "success",
        imageElevation = 4,
        title = "User card type 2",
        subtitle = "a subtitle here",
        bs4ProgressBar(
         value = 5,
         striped = FALSE,
         status = "info"
         ),
        bs4ProgressBar(
          value = 5,
          striped = TRUE,
          status = "warning",
          width = "20\%"
        )
       )
      )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
