% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{attachmentBlock}
\alias{attachmentBlock}
\title{AdminLTE3 attachment container}
\usage{
attachmentBlock(..., src = NULL, title = NULL, title_url = NULL)
}
\arguments{
\item{...}{Any element.}

\item{src}{Url or path to the image.}

\item{title}{Attachment title.}

\item{title_url}{External link.}
}
\description{
Create an attachment container, nice to wrap articles...
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 shinyApp(
  ui = bs4DashPage(
    bs4DashNavbar(),
    bs4DashSidebar(),
    bs4DashControlbar(),
    bs4DashBody(
     bs4Card(
      title = "Attachment example",
      attachmentBlock(
       src = "http://kiev.carpediem.cd/data/afisha/o/2d/c7/2dc7670333.jpg",
       title = "Test",
       title_url = "http://google.com",
       "This is the content"
      )
     )
    ),
    title = "AttachmentBlock"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
