% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{cardProfile}
\alias{cardProfile}
\title{AdminLTE3 card profile}
\usage{
cardProfile(..., src = NULL, title = NULL, subtitle = NULL)
}
\arguments{
\item{...}{Any element such as \link{cardProfileItemList}.}

\item{src}{Profile image, if any.}

\item{title}{Title.}

\item{subtitle}{Subtitle.}
}
\description{
Create card profile
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(
      bs4SidebarMenu(
       bs4SidebarHeader("Main content"),
       bs4SidebarMenuItem(
         "Profile Card",
         tabName = "profile_card",
         icon = "desktop"
       )
      )
     ),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      bs4TabItems(
       bs4TabItem(
         tabName = "profile_card",
         bs4Card(
          status = "primary",
          solidHeader = TRUE,
          cardProfile(
           src = "https://adminlte.io/themes/AdminLTE/dist/img/user4-128x128.jpg",
           title = "Nina Mcintire",
           subtitle = "Software Engineer",
           cardProfileItemList(
            bordered = TRUE,
            cardProfileItem(
             title = "Followers",
             description = 1322
            ),
            cardProfileItem(
             title = "Following",
             description = 543
            ),
            cardProfileItem(
             title = "Friends",
             description = 13287
            )
           )
          )
        )
       )
      )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
