% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_05_advance.R
\name{granger_test}
\alias{granger_test}
\title{Granger causality test (bivariate).}
\usage{
granger_test(formula, data, lags = 1:5, test.reverse = FALSE)
}
\arguments{
\item{formula}{Model formula like \code{y ~ x}.}

\item{data}{Data frame.}

\item{lags}{Time lags. Default is \code{1:5}.}

\item{test.reverse}{Whether to test reverse causality. Default is \code{FALSE}.}
}
\value{
No return value.
}
\description{
Granger test of predictive causality (between two time series)
using the \code{\link[lmtest:grangertest]{lmtest::grangertest()}} function.
}
\details{
The Granger causality test examines whether
the lagged values of a predictor
have any incremental role in predicting an outcome
if controlling for the lagged values of the outcome itself.
}
\examples{
granger_test(chicken ~ egg, data=lmtest::ChickEgg)
granger_test(chicken ~ egg, data=lmtest::ChickEgg, lags=1:10, test.reverse=TRUE)

}
\seealso{
\code{\link{ccf_plot}},
\code{\link{granger_causality}}
}
