% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpvaltreat.R
\name{tpvaltreat}
\alias{tpvaltreat}
\title{Hypothesis testing using the Student t Distribution with H0: abs(mu) <= delta}
\usage{
tpvaltreat(coefficients, delta, se, df, log = FALSE)
}
\arguments{
\item{coefficients}{a vector}

\item{delta}{a postive cutoff}

\item{se}{standard error}

\item{df}{degrees of freedom}

\item{log}{the probability is in log-scale}
}
\description{
Hypothesis testing using the Student t Distribution with H0: abs(mu) <= delta
}
\examples{
x=seq(from=-30, to=30, length.out=100)

data=do.call(
  rbind
  , lapply(
    seq_len(10)
    , function(delta)
      rbind(
        data.frame(x, pval=tpvaltreat(x, delta=delta, se=1, df=3), delta=delta)
        )
    )
  )

ggplot2::qplot(x, pval, data=data, color=as.factor(delta), linetype=as.factor(delta), geom='line')
}
\keyword{htest}
