% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{GIBDist}
\alias{GIBDist}
\alias{dGIB}
\alias{rGIB}
\alias{summary_GIB}
\title{Gamma-Inverse Beta distribution}
\usage{
dGIB(x, a, alpha, beta, rho)

rGIB(n, a, alpha, beta, rho)

summary_GIB(a, alpha, beta, rho, output = "list", ...)
}
\arguments{
\item{x}{vector of quantiles}

\item{a}{non-negative shape parameter of the Gamma distribution}

\item{alpha,beta}{non-negative shape parameters of the mixing Beta distribution}

\item{rho}{rate parameter}

\item{n}{number of observations to be simulated}

\item{output}{type of the \code{summary_GIB} output: \code{"list"} to return a list, \code{"pandoc"} to print a table}

\item{...}{arguments passed to \code{\link[=pander]{pander.data.frame}}}
}
\value{
\code{dGIB} gives the density, \code{rGIB} samples from the distribution,
and \code{summary_GIB} returns a summary of the distribution.
}
\description{
Density and random  generation for the Gamma-Inverse Beta distribution
with shape parameters \code{a}, \code{alpha}, \code{beta} and rate parameter \code{rho}.






}
\details{
This is the mixture distribution obtained by sampling a value \eqn{b} from a Beta distribution
with shape parameters \eqn{\beta}, \eqn{\alpha}
and then sampling a Gamma distribution with shape \eqn{a} and rate \eqn{\rho/b}.
}
\note{
\code{GIBDist} is a generic name for the functions documented.
}
\examples{
curve(dGIB(x, 3, 4, 2, 2.5), from=0, to=3)
summary_GIB(3, 4, 2, 2.5, output="pandoc", style="grid")
}

