# hybrid methods work ------------------------------------------------------

testthat::test_that(
  desc = "hybrid methods works",
  code = {
    library(lme4)
    # merMord
    set.seed(123)
    lmm_mod <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
    df_lmm <- tidy_parameters(lmm_mod, effects = "fixed")

    # test
    testthat::expect_equal(
      df_lmm$estimate,
      c(251.40510, 10.46729),
      tolerance = 0.001
    )

    testthat::expect_identical(
      names(df_lmm),
      c(
        "term", "estimate", "std.error", "conf.low", "conf.high", "statistic",
        "df.error", "p.value"
      )
    )

    testthat::expect_equal(
      dim(glance_performance(lmm_mod, effects = "fixed")), c(1L, 10L)
    )

    # lm
    set.seed(123)
    lm_mod <- lm(Reaction ~ Days, sleepstudy)
    df_lm <- tidy_parameters(lm_mod, robust = TRUE)

    # test
    testthat::expect_equal(df_lm$df.error[1], 178L)

    testthat::expect_equal(
      dim(glance_performance(lm_mod, effects = "fixed"))[[1]], 1L
    )

    # mixor object
    set.seed(123)
    library(mixor)
    data("SmokingPrevention")
    SmokingPrevention <- SmokingPrevention[order(SmokingPrevention$class), ]
    suppressWarnings(mod_mixor <-
      mixor(
        formula = thksord ~ thkspre + cc + tv + cctv,
        data = SmokingPrevention,
        id = school,
        link = "logit"
      ))

    # test
    testthat::expect_equal(dim(tidy_parameters(mod_mixor))[[1]], 8L)
    testthat::expect_equal(
      tidy_parameters(mod_mixor),
      tidy_parameters(mod_mixor, effects = "fixed")
    )
    testthat::expect_equal(dim(glance_performance(mod_mixor)), c(1L, 2L))

    # setup
    set.seed(123)
    library(lavaan)

    # model specs
    HS.model <- " visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
              speed   =~ x7 + x8 + x9 "

    # model
    mod_lavaan <-
      lavaan(
        HS.model,
        data = HolzingerSwineford1939,
        auto.var = TRUE,
        auto.fix.first = TRUE,
        auto.cov.lv.x = TRUE
      )

    # test
    testthat::expect_identical(
      tidy_parameters(mod_lavaan, effects = "fixed"),
      tidy_parameters(mod_lavaan, effects = "fixed", exponentiate = TRUE)
    )

    # p-value check
    library(MASS)
    mod <- rlm(stack.loss ~ ., stackloss)
    df_rlm <- tidy_parameters(mod)
    df <- suppressMessages(suppressWarnings(tidy_parameters(tidy(mod))))

    # test
    testthat::expect_equal(dim(df_rlm), c(4L, 8L))
    testthat::expect_is(df, "tbl_df")

    # model
    library(orcutt)
    set.seed(123)
    reg <- stats::lm(formula = mpg ~ wt + qsec + disp, data = mtcars)
    co <- orcutt::cochrane.orcutt(reg)

    df_orcutt <- broomExtra::glance_performance(co)
    # testthat::expect_equal(dim(df_orcutt), c(1L, 9L))
    testthat::expect_is(df_orcutt, "tbl_df")
  }
)
