% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muhaz-tidiers.R
\name{glance.muhaz}
\alias{glance.muhaz}
\title{Glance at a(n) muhaz object}
\usage{
\method{glance}{muhaz}(x, ...)
}
\arguments{
\item{x}{A \code{muhaz} object returned by \code{\link[muhaz:muhaz]{muhaz::muhaz()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\examples{

if (requireNamespace("muhaz", quietly = TRUE)) {
  if (requireNamespace("survival", quietly = TRUE)) {

library(muhaz)
library(survival)

x <- muhaz(ovarian$futime, ovarian$fustat)
tidy(x)
glance(x)

  }
}

}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[muhaz:muhaz]{muhaz::muhaz()}}

Other muhaz tidiers: 
\code{\link{tidy.muhaz}()}
}
\concept{muhaz tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{max.hazard}{Maximal estimated hazard.}
  \item{max.time}{The maximum observed event or censoring time.}
  \item{min.hazard}{Minimal estimated hazard.}
  \item{min.time}{The minimum observed event or censoring time.}
  \item{nobs}{Number of observations used.}

}
