% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brms-tidiers.R
\name{brms_tidiers}
\alias{brms_tidiers}
\alias{tidy.brmsfit}
\title{Tidying methods for a brms model}
\usage{
\method{tidy}{brmsfit}(x, parameters = NA, par_type = c("all",
  "non-varying", "varying", "hierarchical"), robust = FALSE,
  intervals = TRUE, prob = 0.9, ...)
}
\arguments{
\item{x}{Fitted model object from the \pkg{brms} package. See
\code{\link[brms:brmsfit-class]{brms::brmsfit-class()}}.}

\item{parameters}{Names of parameters for which a summary should be
returned, as given by a character vector or regular expressions.
If \code{NA} (the default) summarized parameters are specified
by the \code{par_type} argument.}

\item{par_type}{One of \code{"all"}, \code{"non-varying"},
\code{"varying"}, or \code{"hierarchical"} (can be abbreviated).
See the Value section for details.}

\item{robust}{Whether to use median and median absolute deviation rather
than mean and standard deviation.}

\item{intervals}{If \code{TRUE} columns for the lower and upper bounds of
posterior uncertainty intervals are included.}

\item{prob}{Defines the range of the posterior uncertainty intervals,
such that \code{100 * prob}\% of the parameter's posterior distribution
lies within the corresponding interval.
Only used if \code{intervals = TRUE}.}

\item{...}{Extra arguments, not used}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

When \code{parameters = NA}, the \code{par_type} argument is used
to determine which parameters to summarize.

Generally, \code{tidy.brmsfit} returns
one row for each coefficient, with at least three columns:
\item{term}{The name of the model parameter.}
\item{estimate}{A point estimate of the coefficient (mean or median).}
\item{std.error}{A standard error for the point estimate (sd or mad).}

When \code{par_type = "non-varying"}, only population-level
effects are returned.

When \code{par_type = "varying"}, only group-level effects are returned.
In this case, two additional columns are added:
\item{group}{The name of the grouping factor.}
\item{level}{The name of the level of the grouping factor.}

Specifying \code{par_type = "hierarchical"} selects the
standard deviations and correlations of the group-level parameters.

If \code{intervals = TRUE}, columns for the \code{lower} and
\code{upper} bounds of the posterior intervals computed.
}
\description{
\code{brms} tidiers will soon be deprecated in \code{broom} and there is no ongoing
development of these functions at this time. \code{brms} tidiers are being
developed in the \code{broom.mixed} package, which is not yet on CRAN.
}
\details{
These methods tidy the estimates from
\code{\link[brms:brmsfit]{brms::brmsfit()}}
(fitted model objects from the \pkg{brms} package) into a summary.
}
\examples{
\dontrun{
 library(brms)
 fit <- brm(mpg ~ wt + (1|cyl) + (1+wt|gear), data = mtcars,
            iter = 500, chains = 2)
 tidy(fit)
 tidy(fit, parameters = "^sd_", intervals = FALSE)
 tidy(fit, par_type = "non-varying")
 tidy(fit, par_type = "varying")
 tidy(fit, par_type = "hierarchical", robust = TRUE)
}

}
\seealso{
\code{\link[brms:brms]{brms::brms()}}, \code{\link[brms:brmsfit]{brms::brmsfit()}}
}
