% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_contrasts.R
\name{model_get_contrasts}
\alias{model_get_contrasts}
\alias{model_get_contrasts.model_fit}
\title{Get contrasts used in the model}
\usage{
model_get_contrasts(model)

\method{model_get_contrasts}{model_fit}(model)
}
\arguments{
\item{model}{a model object}
}
\description{
Get contrasts used in the model
}
\examples{
glm(
  am ~ mpg + factor(cyl),
  data = mtcars,
  family = binomial,
  contrasts = list(`factor(cyl)` = contr.sum)
) \%>\%
  model_get_contrasts()
}
\seealso{
Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_n}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_pairwise_contrasts}()},
\code{\link{model_get_response_variable}()},
\code{\link{model_get_response}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_higher_order_variables}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
